package com.elitescloud.cloudt.system.provider.imports.param;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;

/**
 * 员工导入.
 *
 * @author Kaiser（wang shao）
 * @date 2/21/2023
 */
@Data
public class ImportEmployeeBO implements Serializable {
    private static final long serialVersionUID = 9045136963419821599L;

    /**
     * 员工编号
     */
    @NotBlank
    private String code;

    /**
     * 职务
     */
    private String duty;

    /**
     * 登录账号
     */
    @NotBlank
    private String username;

    /**
     * 姓名
     */
    @NotBlank
    private String fullName;

    /**
     * 性别
     */
    private String gender;

    /**
     * 性别
     */
    private String genderName;

    /**
     * 类型
     */
    private String type;

    /**
     * 类型名称
     */
    private String typeName;

    /**
     * 电话
     */
    private String mobile;

    /**
     * 电话
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 是否启用
     */
    private String enabledName;

    /**
     * 是否在职
     */
    private Boolean served;

    /**
     * 入职时间
     */
    private LocalDateTime joinTime;
    /**
     * 入账时间字符串
     */
    private String joinTimeStr;

    /**
     * 所在组织
     */
    private String orgCodes;

    /**
     * 所有角色
     */
    private String roleCodes;

    /**
     * 所在组织
     */
    private Set<Long> orgIds;

    /**
     * 角色ID
     */
    private Set<Long> roleIds;
}
