package com.elitescloud.cloudt.system.provider.job;

/**
 * <p>
 * 功能说明
 * </p >
 *
 * @author niu.chen
 * 2021-09-02
 */

import com.elitescloud.boot.provider.TenantClientProvider;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 * MessageJobClint
 * job  任务执行客户端
 *
 * @author niuchen
 * 2020/5/28
 */
@Component
@Slf4j
public class TestJobHandler {

    @Autowired
    private TenantClientProvider tenantClientProvider;

    /**
     * 消息发送定时任务请求
     */
    @XxlJob(JobConstant.TEST_HANDLER)
    public ReturnT<String> testJobHandler(String param) throws Exception {
        String ip= MDC.get("ip");
        String port=  MDC.get("port");
        XxlJobLogger.log(JobConstant.TEST_HANDLER + "执行"+ip+":"+port);
        TimeUnit.SECONDS.sleep(5);//秒
        /********执行一次消息发送服务****/
        XxlJobLogger.log("执行结果:"+ "执行"+ip+":"+port);

        log.info("租户：{}", tenantClientProvider.getSessionTenant());
        return ReturnT.SUCCESS;
    }
}
