package com.elitescloud.cloudt.system.provider.job.scheduler;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.stereotype.Component;

import java.time.Duration;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/26
 */
@Slf4j
@Component
public class BaseSchedulerConfigurer implements SchedulingConfigurer {

    @Autowired
    private ClearExpiredResourcesTask clearExpiredResourcesTask;

    @Override
    public void configureTasks(@NonNull ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.addFixedRateTask(() -> {
            try {
                clearExpiredResourcesTask.run();
            } catch (Exception e) {
                log.info("删除过期文件异常", e);
            }
        }, Duration.ofDays(2).toMillis());
    }
}
