package com.elitescloud.cloudt.system.provider.job.scheduler;

import com.elitescloud.cloudt.system.model.entity.SysResourceByteDO;
import com.elitescloud.cloudt.system.service.ResourceByteMngService;
import com.elitescloud.cloudt.system.service.repo.ResourceByteRepoProc;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;

/**
 * 删除过期的临时资源.
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/26
 */
@Slf4j
@Component
public class ClearExpiredResourcesTask implements Runnable {

    @Autowired
    private ResourceByteMngService mngService;
    @Autowired
    private ResourceByteRepoProc resourceByteRepoProc;

    @Override
    public void run() {
        var expiredFiles = resourceByteRepoProc.queryExpiredTempResource(LocalDateTime.now().plusDays(2), 50);
        if (expiredFiles.isEmpty()) {
            return;
        }
        for (SysResourceByteDO expiredFile : expiredFiles) {
            mngService.delete(expiredFile.getId());
            log.info("删除过期的临时文件：{}，{}", expiredFile.getResourceKey(), expiredFile.getCreateTime());
        }
    }
}
