package com.elitescloud.cloudt.system.rest;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.param.SysSettingQParam;
import com.elitescloud.cloudt.system.service.ISysSettingService;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;
import java.util.Objects;

/**
 * @author mir
 */
@RestController
@RequestMapping("/sys/settings")
@Api(value = "系统配置维护", tags = {"系统配置维护"})
public class SysSettingController {

    private ISysSettingService sysSettingService;

    @Autowired
    public void setSysSettingService(ISysSettingService sysSettingService) {
        this.sysSettingService = sysSettingService;
    }

    @PostMapping("/q")
    @ApiOperation("检索配置信息")
    public ApiResult<?> search(@RequestBody SysSettingQParam param) {
        val ret = sysSettingService.search(param);
        return ApiResult.ok(ret);
    }

    @GetMapping("/byid/{id}")
    @ApiOperation("根据记录ID获取配置记录")
    public ApiResult<?> oneById(@PathVariable Long id) {
        val ret = sysSettingService.oneById(id);
        if (Objects.isNull(ret)) {
            return ApiResult.fail(ApiCode.NOT_FOUND);
        }
        return ApiResult.ok(ret);
    }

    @GetMapping("/byno/{no}")
    @ApiOperation("根据配置编码获取配置记录")
    public ApiResult<?> oneById(@PathVariable String no) {
        val ret = sysSettingService.oneByNo(no);
        if (Objects.isNull(ret)) {
            return ApiResult.fail(ApiCode.NOT_FOUND);
        }
        return ApiResult.ok(ret);
    }

    @PostMapping
    @ApiOperation("创建配置")
    public ApiResult<?> create(@RequestBody @Valid SysSettingVO setting) {
        val id = sysSettingService.create(setting);
        return ApiResult.ok(id);
    }

    @PutMapping
    @ApiOperation("更改配置值")
    public ApiResult<?> update(@RequestBody SysSettingVO setting) {
        sysSettingService.update(setting);
        return ApiResult.ok();
    }

    @DeleteMapping("/byids")
    @ApiOperation("根据记录ID批量删除配置")
    public ApiResult<?> removeByIds(@RequestBody List<Long> ids) {
        sysSettingService.removeByIds(ids);
        return ApiResult.ok();
    }

    @DeleteMapping("/bynos")
    @ApiOperation("根据配置编码，批量删除配置")
    public ApiResult<?> removeByNos(@RequestBody List<String> nos) {
        sysSettingService.removeByNos(nos);
        return ApiResult.ok();
    }
}
