package com.elitescloud.cloudt.system.rest;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.cas.provider.UserTransferHelper;
import com.elitescloud.boot.auth.config.AuthorizationSdkProperties;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.FileInfoVO;
import com.elitescloud.boot.core.base.SeqNumProvider;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.excel.util.ExcelImportUtil;
import com.elitescloud.boot.exception.BusinessException;
//import com.elitescloud.boot.mq.MessageQueueTemplate;
//import com.elitescloud.boot.mq.common.BaseMessage;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.core.provider.IdGenerator;
import com.elitescloud.cloudt.messenger.Messenger;
import com.elitescloud.cloudt.messenger.model.MessageAccountVO;
import com.elitescloud.cloudt.system.dto.SysUdcDTO;
import com.elitescloud.cloudt.system.provider.SysUdcRpcService;
import com.elitescloud.cloudt.system.provider.mq.SystemMqBinding;
import com.elitescloud.cloudt.system.service.ResourceByteMngService;
import com.elitescloud.cloudt.system.service.old.ISysUserService;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.vo.SysUserDetailsVO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.*;
import lombok.Data;
import lombok.extern.log4j.Log4j2;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.*;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/4/12
 */
@RestController
@RequestMapping(value = "/sys/test", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "接口测试", tags = "【调试】测试")
@Log4j2
@SuppressWarnings({"deprecation", "removal"})
public class SysTestController {

    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired(required = false)
    private RedisUtils redisUtils;
    @Autowired(required = false)
    private SystemMqBinding systemMqBinding;

    @Autowired
    private SysUdcRpcService udcRpcService;
    @Autowired
    private UdcProvider udcProvider;
    @Autowired
    private SeqNumProvider seqNumProvider;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private DiscoveryClient discoveryClient;
//    @Autowired(required = false)
//    private MessageQueueTemplate messageQueueTemplate;
    @Autowired
    private OrgRepoProc orgRepoProc;

    /**
     * 获取当前用户信息
     *
     * @return
     * @throws JsonProcessingException
     */
    @ApiOperation("获取当前用户信息")
    @ApiOperationSupport(order = 3)
    @GetMapping(value = "/users/current")
    public ApiResult<String> getCurrentUser(String req) throws JsonProcessingException {
        var obj = SecurityContextUtil.currentUser();
        if (StringUtils.hasText(req)) {
            throw new BusinessException("异常");
        }
        var res = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        return ApiResult.ok(res);
    }

    @ApiOperation("用户信息获取（模拟登陆）")
    @ApiOperationSupport(order = 10)
    @GetMapping(value = "/user/get")
    public String getUserInfo(String username) throws JsonProcessingException {
        log.info("查询用户信息");
        UserTransferHelper.getInstance(SpringContextHolder.getBean(AuthorizationSdkProperties.class).getAuthServer()).validatePwd(null, null, "123456");
        var obj = sysUserService.getUserByUsername(username);
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
    }

    @ApiOperation("通过ID取得用户明细（新）")
    @ApiOperationSupport(order = 21)
    @GetMapping("/users/details/{id}")
    public ApiResult<SysUserDetailsVO> findDetailsById(@PathVariable Long id) {
        return ApiResult.ok(sysUserService.findDetailsById(id));
    }

    @ApiOperation("模糊查询redis keys")
    @ApiOperationSupport(order = 30)
    @GetMapping(value = "/redis/keys")
    public ApiResult<Set<String>> scanRedisKeys(String prefix, String del) {
        String key = prefix + "*";
        Set<String> keys = redisUtils.getRedisTemplate().keys(key);
        log.info("数量：{}", keys.size());

        List<String> keys1 = redisUtils.scan(key);
        if ("true".equals(del)) {
            if (CollUtil.isNotEmpty(keys)) {
                for (String s : keys) {
                    redisUtils.del(s);
                }
            }
            if (CollUtil.isNotEmpty(keys1)) {
                for (String s : keys1) {
                    redisUtils.del(s);
                }
            }
        }

        return ApiResult.ok(new HashSet<>(keys1));
    }

    /**
     * 测试redis值操作
     *
     * @param key   key
     * @param value value，空时取值
     * @return value
     */

    @ApiOperation("测试redis值操作")
    @ApiOperationSupport(order = 31)
    @GetMapping(value = "/redis/get")
    public ApiResult<String> testRedisValue(String key, String value) {
        if (!StringUtils.hasText(key)) {
            return ApiResult.fail("key为空");
        }

        if (StringUtils.hasText(value)) {
            redisUtils.set(key, value);
            return ApiResult.ok("设置值：" + value);
        }

        value = (String) redisUtils.get(key);
        return ApiResult.ok("取得值：" + value);
    }

    @ApiOperation("MQ发送消息")
    @ApiOperationSupport(order = 40)
    @GetMapping(value = "/mq/send")
    public ApiResult<String> testSendMq() {
        Message<String> message = MessageBuilder.withPayload("hello")
                .setHeader("un", "wangs")
                .build();
        systemMqBinding.systemOutput().send(message);

        return ApiResult.ok("success");
    }

//    @ApiOperation("CloudtMQ")
//    @ApiOperationSupport(order = 41)
//    @GetMapping(value = "/mq/cloudt")
//    public ApiResult<String> cloudtMq(@RequestParam(name = "channel", required = false) String channel,
//                                      @RequestParam(name = "pub", required = false, defaultValue = "false") Boolean pub) throws Exception {
//        if (messageQueueTemplate == null) {
//            return ApiResult.fail("未启用");
//        }
//        if (CharSequenceUtil.isBlank(channel)) {
//            channel = "wangs_demo";
//        }
//
//        String key = DatetimeUtil.currentTimeLong();
//
//        BaseMessage message = new BaseMessage() {
//            private static final long serialVersionUID = 4013233346217130403L;
//
//            @Override
//            public String getBusinessKey() {
//                return key;
//            }
//        };
//
//        if (Boolean.TRUE.equals(pub)) {
//            messageQueueTemplate.publishMessage(channel, message);
//        } else {
//            messageQueueTemplate.sendMessage(channel, message);
//        }
//
//        return ApiResult.ok(key);
//    }

    @ApiOperation("测试获取服务器信息")
    @ApiOperationSupport(order = 50)
    @GetMapping(value = "/server/info")
    public ApiResult<Map<String, Object>> testGetServerInfo(HttpServletRequest request) {
        orgRepoProc.queryParentNameForType(List.of(22L), "company", true);
        Map<String, Object> result = new HashMap<>();
        result.put("请求路径", request.getRequestURL());
        result.put("客户端IP", HttpServletUtil.currentClientIp());
        result.put("header-origin", request.getHeader(HttpHeaders.ORIGIN));
        result.put("header-host", request.getHeader(HttpHeaders.HOST));
        result.put("header-referer", request.getHeader(HttpHeaders.REFERER));
        result.put("解析得域名", HttpServletUtil.obtainDomain(request));

        return ApiResult.ok(result);
    }

    @ApiOperation("获取所有请求头")
    @ApiOperationSupport(order = 51)
    @GetMapping(value = "/request/headers")
    public ApiResult<MultiValueMap<String, String>> testGetHeaders(HttpServletRequest request) {
        var headers = HttpServletUtil.getHeaders(request);
        log.info("请求头：{}", headers);

        return ApiResult.ok(headers);
    }

    @ApiOperation("获取MDC值")
    @ApiOperationSupport(order = 52)
    @GetMapping(value = "/mdc/value")
    public ApiResult<String> testMdc(@RequestParam(name = "name", required = false) String name) {
//        var traceId = Span.current().getSpanContext().getTraceId();
//        log.info("traceId:{}", traceId);
        if (CharSequenceUtil.isBlank(name)) {
            return ApiResult.ok(JSONUtil.toJsonString(MDC.getCopyOfContextMap()));
        }

        taskExecutor.execute(() -> {
            log.info("异步线程：{}", JSONUtil.toJsonString(MDC.getCopyOfContextMap()));
        });

        var value = MDC.get(name);
        return ApiResult.ok(value);
    }

    @ApiOperation("上传资源文件")
    @ApiOperationSupport(order = 53)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "file", value = "文件"),
            @ApiImplicitParam(name = "businessType", value = "业务类型"),
    })
    @PostMapping(value = "/res/upload")
    public ApiResult<FileInfoVO> testUploadResource(@RequestParam(name = "file") MultipartFile file,
                                                    @RequestParam(name = "businessType") String businessType) {
        return SpringContextHolder.getBean(ResourceByteMngService.class).saveResource(file, businessType);
    }

    @ApiOperation("查询UDC信息")
    @ApiOperationSupport(order = 60)
    @GetMapping(value = "/udc/get")
    public ApiResult<SysUdcDTO> getUdc(String appCode, String udcCode) {
        return udcRpcService.get(appCode, udcCode);
    }

    @ApiOperation("查询UDC列表")
    @ApiOperationSupport(order = 61)
    @PostMapping(value = "/udc/list")
    public ApiResult<List<SysUdcDTO>> listUdc(String appCode, @RequestBody Set<String> udcCodes) {
        return udcRpcService.listByUdcCode(appCode, udcCodes);
    }

    @ApiOperation("获取UDC信息（缓存）")
    @ApiOperationSupport(order = 62)
    @GetMapping(value = "/udc/get/cache")
    public ApiResult<SysUdcDTO> getUdcCache(String appCode, String udcCode) {

        var udcDto = udcProvider.getByUdcCode(appCode, udcCode);
        return ApiResult.ok(udcDto);
    }

    @ApiOperation("生成ID")
    @ApiOperationSupport(order = 63)
    @GetMapping(value = "/id/next")
    public ApiResult<Serializable> idNext() {
        return ApiResult.ok(IdGenerator.generate());
    }

    @ApiOperation("发号器")
    @ApiOperationSupport(order = 64)
    @GetMapping(value = "/seq/next")
    public ApiResult<List<String>> seq(String appCode, String ruleCode, Integer num) {
        // 本机
//        var value = SpringContextHolder.getBean(SeqNumFactory.class).generateCode(appCode, ruleCode, null, ObjectUtil.defaultIfNull(num, 1));
        // rpc
        var value = seqNumProvider.generateCode(appCode, ruleCode, null, ObjectUtil.defaultIfNull(num, 1));
        return ApiResult.ok(value);
    }

    @ApiOperation("发送站内信")
    @ApiOperationSupport(order = 65)
    @PostMapping(value = "/messenger/site")
    public ApiResult<String> testSendSiteMsg(@RequestBody MessageSiteVO siteVO) {
        var msgId = Messenger.siteMessage()
                .setSubject(CharSequenceUtil.blankToDefault(siteVO.getSubject(), "未提供标题"))
                .setContent(CharSequenceUtil.blankToDefault(siteVO.getContent(), "未提供内容"))
                .setReceiverList(List.of(new MessageAccountVO(CharSequenceUtil.blankToDefault(siteVO.getUsername(), "admin"))))
                .setBusinessType(CharSequenceUtil.blankToDefault(siteVO.getBusinessType(), "approve"))
                .setBusinessParams(siteVO.getBusinessParams())
                .build()
                .send();
        return ApiResult.ok(msgId);
    }

    @ApiOperation("发送邮件")
    @ApiOperationSupport(order = 66)
    @ApiImplicitParam(name = "emailAddress", value = "邮箱地址", required = true)
    @PostMapping(value = "/messenger/email")
    public ApiResult<String> testSendEmailMsg(@RequestParam(name = "emailAddress") String emailAddress) {
        Assert.hasText(emailAddress, "邮件地址为空");
        var msgId = Messenger.email()
                .setSubject("测试邮件")
                .setContent("邮件内容")
                .setReceiverList(List.of(new MessageAccountVO(emailAddress, "wangs")))
                .build()
                .send();
        return ApiResult.ok(msgId);
    }

    @ApiOperation("发送短信")
    @ApiOperationSupport(order = 67)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "mobile", value = "手机号", required = true),
            @ApiImplicitParam(name = "templateCode", value = "模板编码"),
    })
    @PostMapping(value = "/messenger/sms")
    public ApiResult<String> testSendSmsMsg(@RequestParam(name = "mobile") String mobile,
                                            @RequestParam(name = "templateCode", required = false) String templateCode) {
        Assert.hasText(mobile, "手机号为空");
        var msgId = Messenger.templateSms()
                .setSubject("标题")
                .setContent("内容")
                .setReceiverList(List.of(new MessageAccountVO(mobile)))
                .setTemplateCode(CharSequenceUtil.blankToDefault(templateCode, "SMS_269440639"))
                .setTemplateParam(Map.of("code", "147852"))
                .build()
                .send();
        return ApiResult.ok(msgId);
    }

    @ApiOperation("发送App消息")
    @ApiOperationSupport(order = 68)
    @ApiImplicitParam(name = "username", value = "用户名", required = true)
    @PostMapping(value = "/messenger/app")
    public ApiResult<String> testSendAppMsg(@RequestParam(name = "username") String username) {
        Assert.hasText(username, "账号为空");
        var msgId = Messenger.appMessage()
                .setSubject("你有新的审批提醒")
                .setContent("这是待审批的内容...")
                .setReceiverList(List.of(new MessageAccountVO(username)))
                .setBusinessType("appr_order")
                .setBusinessParams(Map.of("code", "147852"))
                .build()
                .send();
        return ApiResult.ok(msgId);
    }


    @ApiOperation("获取注册的服务")
    @ApiOperationSupport(order = 71)
    @PostMapping(value = "/service/list")
    public ApiResult<String> testGetServices(String instanceName) {
        log.info("服务列表：{}", String.join(",", discoveryClient.getServices()));
        if (StringUtils.hasText(instanceName)) {
            for (ServiceInstance instance : discoveryClient.getInstances(instanceName)) {
                log.info("instanceId：{}, serviceId：{}, Host：{}, Port：{}, Uri：{}, metadata：{}", instance.getInstanceId(), instance.getServiceId(), instance.getHost(),
                        instance.getPort(), instance.getUri(), instance.getMetadata());
            }
        }
        return ApiResult.ok("success");
    }

    @ApiOperation("解析导入的UDC")
    @ApiOperationSupport(order = 81)
    @PostMapping(value = "/udc/import")
    public ApiResult<String> testImportUdc(@RequestParam("file") MultipartFile file) throws Exception {
        if (file == null || file.isEmpty()) {
            return ApiResult.fail("上传文件为空");
        }

        var sqlList = this.generateUdcSql(file);
        return ApiResult.ok(String.join("", sqlList));
    }

    private List<String> generateUdcSql(MultipartFile file) throws Exception {
        List<Map<String, Object>> dataList = (List<Map<String, Object>>) ExcelImportUtil.instance(file.getInputStream())
                .headRow(1)
                .sheetNo(Set.of(1))
                .dataType(null, 1)
                .readAllSync();
        log.info("数据量：{}", dataList.size());

        List<Map<String, Object>> udcParamList = new ArrayList<>();
        List<Map<String, Object>> udcValueParamList = new ArrayList<>();

        Set<String> existsUdc = new HashSet<>();
        Set<String> existsUdcValue = new HashSet<>();
        int i = 0;
        long id = System.currentTimeMillis();
        for (Map<String, Object> data : dataList) {
            i++;
            Map<String, Object> udcParams = new HashMap<>();
            Map<String, Object> udcValueParams = new HashMap<>();

            var appCode = data.get("app_code");
            var udcCode = data.get("udc_code");
            var udcValueCode = data.get("udc_value_code");

            if (!existsUdc.contains(appCode + ":" + udcCode)) {
                udcParams.put("id", id + i);
                udcParams.put("tenant_id", -1);

                udcParams.put("app_code", appCode);
                udcParams.put("udc_code", udcCode);
                udcParams.put("udc_name", data.get("udc_name"));
                udcParams.put("udc_describe", data.get("udc_describe"));

                existsUdc.add(appCode + ":" + udcCode);
                udcParamList.add(udcParams);
            }

            if (existsUdcValue.contains(appCode + ":" + udcCode + ":" + udcValueCode)) {
                System.out.println("已存在：" + appCode + ":" + udcCode + ":" + udcValueCode);
                continue;
            }
            existsUdcValue.add(appCode + ":" + udcCode + ":" + udcValueCode);

            udcValueParams.put("id", id + i);
            udcValueParams.put("tenant_id", -1);
            udcValueParams.put("app_code", appCode);
            udcValueParams.put("udc_code", udcCode);
            udcValueParams.put("udc_value_code", udcValueCode);
            udcValueParams.put("udc_value_name", data.get("udc_value_name"));
            udcValueParams.put("udc_order", data.get("udc_order"));
            udcValueParams.put("udc_value_describe", data.get("udc_value_describe"));
            udcValueParamList.add(udcValueParams);
        }

        List<String> sqlList = new ArrayList<>();
        for (Map<String, Object> udc : udcParamList) {
            udc.put("allow_update", 1);
            udc.put("allow_add_value", 0);

            sqlList.add(this.convertSql("sys_platform_udc", udc));
        }
        for (Map<String, Object> udc : udcValueParamList) {
            udc.put("allow_start", 1);
            udc.put("allow_default", 1);

            sqlList.add(this.convertSql("sys_platform_udc_value", udc));
        }

        return sqlList;
    }

    private String convertSql(String tableName, Map<String, Object> params) {
        List<String> fieldList = new ArrayList<>();
        List<String> valueList = new ArrayList<>();

        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getValue() == null) {
                continue;
            }

            if (entry.getValue() instanceof String) {
                if (CharSequenceUtil.isBlank((String) entry.getValue())) {
                    continue;
                }

                valueList.add("'" + entry.getValue() + "'");
            } else {
                valueList.add(entry.getValue().toString());
            }
            fieldList.add(entry.getKey());
        }

        return "insert into " + tableName + "(" + String.join(", ", fieldList) + ") values "
                + "(" + String.join(", ", valueList) + ");";
    }

    @Data
    @ApiModel(description = "站内信信息")
    public static class MessageSiteVO implements Serializable {

        @ApiModelProperty(value = "标题", position = 1, required = true)
        private String subject;

        @ApiModelProperty(value = "内容", position = 2, required = true)
        private String content;

        @ApiModelProperty(value = "接收人账号", position = 3, required = true)
        private String username;

        @ApiModelProperty(value = "业务类型", position = 4, required = true)
        private String businessType;

        @ApiModelProperty(value = "业务扩展参数", position = 5)
        private Map<String, String> businessParams;
    }
}
