package com.elitescloud.cloudt.system.rest;

import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.service.SysWatermarkConfigService;
import com.elitescloud.cloudt.system.service.param.SysWatermarkConfigCreateParam;
import com.elitescloud.cloudt.system.service.param.SysWatermarkConfigQueryParam;
import com.elitescloud.cloudt.system.service.param.SysWatermarkConfigUpdateParam;
import com.elitescloud.cloudt.system.service.vo.SysWatermarkConfigVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author roman.zhang
 * @since 2022-03-25 15:17:51
 */
@RestController
@RequestMapping("/sys/watermarkConfig")
@Api(value = "系统水印配置", tags = {"系统水印配置"})
@RequiredArgsConstructor
public class SysWatermarkConfigController {
  
    private final SysWatermarkConfigService sysWatermarkConfigService;


    @GetMapping("/findOne")
    @ApiOperation("获取系统水印配置")
    ApiResult<SysWatermarkConfigVO>  findOne(){
        return sysWatermarkConfigService.findOne().map(ApiResult::ok)
                .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }
    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("/findIdOne/{id}")
    @ApiOperation("通过主键查询单条数据")
    ApiResult<SysWatermarkConfigVO>  findIdOne(@PathVariable  Long id){
        return sysWatermarkConfigService.findIdOne(id).map(ApiResult::ok)
        .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }
    
    /**
     * 根据关键字段查询数据
     * @param key 参数
     * @return 数据
     */
    @GetMapping("/findCodeOne/{key}")
    @ApiOperation("根据关键字段查询数据")
    public ApiResult<SysWatermarkConfigVO>  findCodeOne(@PathVariable  String key){
        return sysWatermarkConfigService.findCodeOne(key).map(ApiResult::ok)
        .orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }
    
    /**
     * 分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询")
    public  ApiResult<PagingVO<SysWatermarkConfigVO>> search(@RequestBody SysWatermarkConfigQueryParam param){
        val ret = sysWatermarkConfigService.search(param);
        return ApiResult.ok(ret); 
    }
    
     /**
     * 新增数据
     *
     * @param param 新增数据
     * @return 新增数据情况
     */
    @PostMapping("/createOne")
    @ApiOperation("新增数据")
    public ApiResult<Object> createOne(@RequestBody SysWatermarkConfigCreateParam param){
         return  ApiResult.ok( sysWatermarkConfigService.createOne(param));
    }
    /**
     * 批量新增数据
     *
     * @param list 对象集合
     */
    @PostMapping("/createBatch")
    @ApiOperation("批量新增数据")
    public ApiResult<Object> createBatch(@RequestBody List<SysWatermarkConfigCreateParam> list){
        return ApiResult.ok( sysWatermarkConfigService.createBatch(list));
    }
    
   /**
     * 修改数据
     *
     * @param param 修改对象 
     * @return 修改数据详情
     */
    @PutMapping("/update")
    @ApiOperation("修改数据")
    public ApiResult<Object> update(@RequestBody SysWatermarkConfigUpdateParam param){
        sysWatermarkConfigService.update(param);
        return ApiResult.ok();
    }
    
    /**
     * 根据主键删除数据
     *
     * @param  id 主键
     * @return 删除情况
     */
    @DeleteMapping("/deleteOne/{id}")
    @ApiOperation("根据主键删除数据")
    public ApiResult<Object> deleteOne(@PathVariable Long id){
        sysWatermarkConfigService.deleteOne(id);
        return ApiResult.ok();
    }
    
    /**
     * 批量删除
     *
     * @param ids 删除数据集合
     */
    @DeleteMapping("/deleteBatch")
    @ApiOperation("批量删除")
    public ApiResult<Object> deleteBatch(@RequestBody List<Long> ids){
        sysWatermarkConfigService.deleteBatch(ids);
        return ApiResult.ok();
    }
    
    /**
     * 逻辑删除
     *
     * @param id 更新数据
     */
    @PutMapping("/updateDeleteFlag/{id}")
    @ApiOperation("逻辑删除")
    public ApiResult<Object> updateDeleteFlag(@PathVariable Long id){
        sysWatermarkConfigService.updateDeleteFlag(id);
        return ApiResult.ok();
    }
}


