package com.elitescloud.cloudt.system.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.param.CodeNameParam;
import com.elitescloud.cloudt.platform.service.SysPlatformAppService;
import com.elitescloud.cloudt.system.provider.SysAppRpcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/9/20
 */
@RestController
@RequestMapping(value = SysAppRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysAppRpcServiceImpl implements SysAppRpcService {

    @Autowired(required = false)
    private SysPlatformAppService appService;

    @Override
    public ApiResult<List<CodeNameParam>> allApp() {
        var appList = appService.all().getData();
        if (CollectionUtils.isEmpty(appList)) {
            return ApiResult.ok(Collections.emptyList());
        }
        var dataList = appList.stream().map(t -> new CodeNameParam(t.getCode(), t.getName())).collect(Collectors.toList());
        return ApiResult.ok(dataList);
    }
}
