package com.elitescloud.cloudt.system.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.platform.convert.MenusConvert;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformMenusDO;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusRepo;
import com.elitescloud.cloudt.system.dto.resp.SysPlatformMenusDTO;
import com.elitescloud.cloudt.system.provider.SysMenuRpcService;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * .
 *
 * @author kevin nc
 * 2023/6/25
 */
@RestController
@RequestMapping(value = SysMenuRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysMenuRpcServiceImpl implements SysMenuRpcService {
    private final SysPlatformMenusRepo sysPlatformMenusRepo;
    //    private final SysPlatformMenusRepoProc sysPlatformMenusRepoProc;
    private static final QSysPlatformMenusDO QDO = QSysPlatformMenusDO.sysPlatformMenusDO;


    public SysMenuRpcServiceImpl(SysPlatformMenusRepo sysPlatformMenusRepo) {
        this.sysPlatformMenusRepo = sysPlatformMenusRepo;
    }

    @Override
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @TenantOrgTransaction(useTenantOrg = false )
    public ApiResult<List<SysPlatformMenusDTO>> getPlatformMenuByAppCodeList(List<String> appCodeList) {
        List<SysPlatformMenusDTO> listDto = new ArrayList<>();
        sysPlatformMenusRepo.findAll(QDO.menusAppCode.in(appCodeList))
                .iterator().forEachRemaining(sysPlatformMenusDO -> {
                    listDto.add(MenusConvert.INSTANCE.sysPlatformDOToSysPlatformDTO(sysPlatformMenusDO));
                });
        return ApiResult.ok(listDto);
    }

    @Override
    @TenantTransaction(isolateType = TenantIsolateType.DEFAULT)
    @TenantOrgTransaction(useTenantOrg = false )
    public ApiResult<List<SysPlatformMenusDTO>> getTenantMenuByAppCodeList(Long tenantId,
                                                                           List<String> appCodeList) {
        List<SysPlatformMenusDTO> listDto = new ArrayList<>();
        sysPlatformMenusRepo.findAll(QDO.menusAppCode.in(appCodeList).and(QDO.tenantId.eq(tenantId)))
                .iterator().forEachRemaining(sysPlatformMenusDO -> {
                    listDto.add(MenusConvert.INSTANCE.sysPlatformDOToSysPlatformDTO(sysPlatformMenusDO));
                });
        return ApiResult.ok(listDto);
    }
}
