package com.elitescloud.cloudt.system.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.ThirdApiLogDTO;
import com.elitescloud.cloudt.system.dto.req.ThirdApiLogQueryDTO;
import com.elitescloud.cloudt.system.provider.SysThirdApiLogRpcService;
import com.elitescloud.cloudt.system.service.ThirdApiLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/4
 */
@RestController
@RequestMapping(value = SysThirdApiLogRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysThirdApiLogRpcServiceImpl implements SysThirdApiLogRpcService {

    private ThirdApiLogService service;

    @Override
    public ApiResult<Long> saveLog(ThirdApiLogDTO logDTO) {
        return service.saveLog(logDTO);
    }

    @Override
    public ApiResult<PagingVO<ThirdApiLogDTO>> queryByPage(ThirdApiLogQueryDTO requestDTO) {
        return service.queryByPage(requestDTO);
    }

    @Autowired
    public void setService(ThirdApiLogService service) {
        this.service = service;
    }
}
