package com.elitescloud.cloudt.system.rpc;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.param.*;
import com.elitescloud.cloudt.system.service.SysUserService;
import com.elitescloud.cloudt.system.service.UserMngService;
import com.elitescloud.cloudt.system.service.old.ISysUserService;
import com.elitescloud.cloudt.system.vo.SysPermissionVO;
import com.elitescloud.cloudt.system.vo.SysRoleVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * <pre>
 * 系统用户操作逻辑服务类
 * </pre>
 *
 * @author Michael Li
 * 2020/6/16
 */
@RestController
@RequestMapping(value = SysUserService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysUserRpcProviderServiceImpl implements SysUserService {

    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private UserMngService userMngService;

    /**
     * 根据查询条件检索用户信息
     *
     * @param param 查询条件对象
     * @return 用户信息集合
     */
    @Override
    public PagingVO<SysUserVO> search(SysUserQueryParam param) {
        return sysUserService.search(param);
    }

    /**
     * @param id
     * @return
     */
    @Override
    public SysUserDTO getById(Long id) {
        return sysUserService.getById(id);
    }

    @Override
    public List<SysUserVO> getByIds(List<Long> ids) {
        return sysUserService.getByIds(ids);
    }

    /**
     * 根据用户账号，返回脱敏的用户信息，VO
     *
     * @param username 用户账号
     * @return 脱敏的用户信息
     */
    @Override
    public SysUserDTO getUserByUsername(String username) {
        return sysUserService.getUserByUsername(username);
    }

    /**
     * 创建新用户
     *
     * @param user 用户账号信息
     * @return 新用户账号ID
     */
    @Override
    public Long create(SysUserNewParam user) {
        return sysUserService.create(user, null);
    }

    /**
     * 创建新用户
     *
     * @param user 用户账号信息
     * @return 新用户账号ID
     */
    @Override
    public Long create(SysUserNewParam user, String password) {
        return sysUserService.create(user, password);
    }

    @Override
    public void update(SysUserUpdateParam user) {
        sysUserService.update(user);
    }

    @Override
    public Boolean switchUserStatus(Long id) {
        return sysUserService.switchUserStatus(id);
    }

    /**
     * 用户 批量启用/禁用
     *
     * @param param 参数
     */
    @Override
    public void batchSwitchUserStatus(SysUserBatchSwitchParam param) {
        sysUserService.batchSwitchUserStatus(param);
    }

    @Override
    public Set<SysRoleVO> listRolesByUsername(String username) {
        return sysUserService.listRolesByUsername(username);
    }

    @Override
    public SysUserDTO current() {
        return sysUserService.current();
    }

    @Override
    public List<SysPermissionVO> currentMenu() {
        return Collections.emptyList();
    }

    @Override
    public Set<SysPermissionVO> currentActions() {
        return Collections.emptySet();
    }

    @Override
    public Set<SysPermissionVO> currentMenuActions(Long menuId) {
        return Collections.emptySet();
    }

    @Override
    public void deleteBatch(List<Long> idList) {
        sysUserService.deleteBatch(idList);
    }

    @Override
    public void updatePassword(SysPasswordUpdate update) {
        userMngService.updatePassword(update);
    }
}
