package com.elitescloud.cloudt.system.rpc.dpr;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.convert.SysDprRoleApiRuleConvert;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;

import com.elitescloud.cloudt.system.model.vo.sbean.SysDprRoleApiDataRuleListQueryBean;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;
import com.elitescloud.cloudt.system.spi.DprSysRuleSysInternallyValueSpi;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;


/**
 * @author : chen
 * <p>
 * 2022-11-24 14:22
 */
@Slf4j
public class RoleAppApiDataPermissionRpcServiceUtil {


    /**
     * @param userInfo 当前用户信息
     *                 valueServiceSpi 接口
     *                 sysBean 角色规则对象
     * @return SysDprRoleApiDataRuleListQueryDTO 角色规则对象包括规则值
     * @description 设置系统内置规则值 会根据不同的规则策略动态获取。
     */
    public static List<SysDprRoleApiDataRuleListQueryDTO> setSysSysDprRoleApiRuleValue(DprSysRuleSysInternallyValueSpi valueServiceSpi,
                                                                                       GeneralUserDetails userInfo,
                                                                                       List<SysDprRoleApiDataRuleListQueryBean> sysBean) {
        Map<String, DprRuleValueSysInternallyBo> dprSysInternallyGroupMap = new HashMap<>(16);
        List<SysDprRoleApiDataRuleListQueryDTO> sysDprRoleApiDataRuleList =
                sysBean.stream().map(sysDprRoleApiDataRuleListQueryBean -> {
                    var ruleDTO = SysDprRoleApiRuleConvert.INSTANCE.beanToDto(sysDprRoleApiDataRuleListQueryBean);
                    String dprSysInternally = ruleDTO.getDprSysInternally();
                    var dsiEnum = DprSysInternallyEnum.valueOf(dprSysInternally);
                    //本人-下级等内置策略,不同的菜单权限只需要查询一次，没有必要多次循环，已经查询过了存储起来，下次直接使用。
                    DprRuleValueSysInternallyBo valueBo;
                    if (dprSysInternallyGroupMap.containsKey(dsiEnum.name())) {
                        valueBo = dprSysInternallyGroupMap.get(dsiEnum.name());
                    } else {
                        valueBo = valueServiceSpi.getSysInternallyRuleFieldRuleValue(userInfo, ruleDTO, dsiEnum);
                        dprSysInternallyGroupMap.put(dsiEnum.name(), valueBo);
                    }
                    ruleDTO.setDprRuleValue(valueBo.getDprRuleValue());
                    ruleDTO.setDprRuleValueDeclare(valueBo.getDprRuleValueDeclare());
                    ruleDTO.setDprRuleFieldType(valueBo.getDprRuleFieldType());
                    ruleDTO.setDprRuleFieldTypeName(valueBo.getDprRuleFieldTypeName());
                    return ruleDTO;
                }).collect(Collectors.toList());
        return sysDprRoleApiDataRuleList;
    }

    /**
     * 业务数据集设置规则值
     */
    public static List<SysDprRoleApiDataRuleListQueryDTO> setBusinessSysDprRoleApiRuleValue(GeneralUserDetails userInfo,
                                                                                            List<SysDprRoleApiDataRuleListQueryBean> businessBean) {
        var beanValueList = businessBean.stream().map(sysDprRoleApiDataRuleListQueryBean -> {
            var ruleDTO = SysDprRoleApiRuleConvert.INSTANCE.beanToDto(sysDprRoleApiDataRuleListQueryBean);
            Assert.hasText(ruleDTO.getRoleRuleValue(), "值空，请检查是否角色中配置了自定义值。Business规则：" + ruleDTO.getId());
            //设置自定义规则的规则值
            ruleDTO.setDprRuleValue(ruleDTO.getRoleRuleValue());
            return ruleDTO;
        }).collect(Collectors.toList());
        return beanValueList;
    }

    /**
     * 自定义数据集设置规则值
     */
    public static List<SysDprRoleApiDataRuleListQueryDTO> setCustomSysDprRoleApiRuleValue(GeneralUserDetails userInfo,
                                                                                          List<SysDprRoleApiDataRuleListQueryBean> businessBean) {
        var beanValueList = businessBean.stream().map(sysDprRoleApiDataRuleListQueryBean -> {
            var ruleDTO = SysDprRoleApiRuleConvert.INSTANCE.beanToDto(sysDprRoleApiDataRuleListQueryBean);
            Assert.hasText(ruleDTO.getRoleRuleValue(), "值空，请检查是否角色中配置了自定义值。Custom规则：" + ruleDTO.getId());
            //设置自定义规则的规则值
            ruleDTO.setDprRuleValue(ruleDTO.getRoleRuleValue());
            return ruleDTO;
        }).collect(Collectors.toList());
        return beanValueList;
    }


//    @Deprecated
//    public static void setSysDprRoleApiRuleGroupValue(
//            GeneralUserDetails userInfo, SysDprRoleApiDataRuleListQueryDTO ruleDTO,
//            List<SysDprRoleRuleGroupRuleAndValueListBean> sValueList,
//            SysDprRoleApiRuleGroupDTO sysDprRoleApiRuleGroupDTO) {
//            //自定义规则
//        if (ruleDTO.getDprRuleValueType().equals(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_CUSTOM.name())) {
//            //设置自定义规则的规则值
//            setRuleValueCustom(userInfo, ruleDTO, sValueList, sysDprRoleApiRuleGroupDTO);
//        } else if (ruleDTO.getDprRuleValueType().equals(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_SYS.name())) {
//            //设置系统内置规则值， 计算内置的值
//            setRuleValueSys(userInfo, ruleDTO);
//        } else if (ruleDTO.getDprRuleValueType().equals(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_FIXED.name())) {
//            //todo 固定值无需处理
//        }
//     }

//    /**
//     * @param @param null
//     * @return
//     * @description 私有方法，设置系统内置规则值， 计算系统内置类型的值
//     */
//    private static void setRuleValueSys(DprSysRuleSysInternallyValueSpi valueServiceSpi, GeneralUserDetails userInfo, SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
//
////        ServiceLoader<DprSysRuleSysInternallyValueSpi> valueSpiLoader = ServiceLoader.load(DprSysRuleSysInternallyValueSpi.class);
////        var valueServiceSpiList = valueSpiLoader.stream().collect(Collectors.toList());
////        if (valueServiceSpiList.isEmpty()) {
////            throw new RuntimeException("规则值计算SPI异常，无法找到默认SPI实现");
////        }
////
////        //SPI策略获取
////        ServiceLoader.Provider<DprSysRuleSysInternallyValueSpi> valueServiceSpi =
////                getValueServiceSpi(valueServiceSpiList);
//
//
//        String dprSysInternally = ruleDTO.getDprSysInternally();
//        var dsiEnum = DprSysInternallyEnum.valueOf(dprSysInternally);
//        var valueBo = valueServiceSpi.getSysInternallyRuleFieldRuleValue(userInfo, ruleDTO, dsiEnum);
//
//        ruleDTO.setDprRuleValue(valueBo.getDprRuleValue());
//        ruleDTO.setDprRuleValueDeclare(valueBo.getDprRuleValueDeclare());
//        ruleDTO.setDprRuleFieldType(valueBo.getDprRuleFieldType());
//        ruleDTO.setDprRuleFieldTypeName(valueBo.getDprRuleFieldTypeName());
//
////        ruleDTO.setDprRuleRelation(valueBo.getDprRuleRelation());
////        ruleDTO.setDprRuleRelationName(valueBo.getDprRuleRelationName());
////        ruleDTO.setDprRuleField(valueBo.getDprRuleField());
////        ruleDTO.setDprRuleFieldDeclare(valueBo.getDprRuleFieldDeclare());
//
////        ruleDTO.setDprRuleCondition(valueBo.getDprRuleCondition());
////        ruleDTO.setDprRuleConditionName(valueBo.getDprRuleConditionName());
//
//    }

    /**
     * @param @param null
     * @return
     * @description SPI策略获取 依赖@Order
     */
    private static ServiceLoader.Provider<DprSysRuleSysInternallyValueSpi> getValueServiceSpi(List<ServiceLoader.Provider<DprSysRuleSysInternallyValueSpi>> valueServiceSpiList) {
        if (valueServiceSpiList.size() == 1) {
            return valueServiceSpiList.get(0);
        } else {
            int valueIndex = 0;
            int minOrder = 0;
            for (int i = 0; i < valueServiceSpiList.size(); i++) {
                var annotation = valueServiceSpiList.get(i).type().getDeclaredAnnotation(Order.class);
                if (annotation != null) {
                    if (minOrder == 0) {
                        minOrder = annotation.value();
                    } else {
                        if (minOrder > annotation.value()) {
                            minOrder = annotation.value();
                            valueIndex = i;
                        }
                    }
                }
            }
            return valueServiceSpiList.get(valueIndex);
        }
    }

//    /**
//     * @param @param null
//     * @return
//     * @description 设置自定义规则的规则值  通过全部自定义值，找到匹配的，然后赋值。
//     */
//    private static void setRuleValueCustom(GeneralUserDetails userInfo, SysDprRoleApiDataRuleListQueryDTO ruleDTO, List<SysDprRoleRuleGroupRuleAndValueListBean> sValueList, SysDprRoleApiRuleGroupDTO sysDprRoleApiRuleGroupDTO) {
//        var sValues = sValueList.stream().filter(r -> {
//            return r.getDprRuleGroupId().equals(sysDprRoleApiRuleGroupDTO.getDprRuleGroupId())
//                    && r.getRoleId().equals(sysDprRoleApiRuleGroupDTO.getRoleId())
//                    && r.getAppId().equals(sysDprRoleApiRuleGroupDTO.getAppId())
//                    && r.getApiId().equals(sysDprRoleApiRuleGroupDTO.getApiId())
//                    && r.getMenuCode().equals(sysDprRoleApiRuleGroupDTO.getMenusCode())
//                    && r.getDprRuleId().equals(ruleDTO.getId());
//        }).collect(Collectors.toList());
//        if (sValues.size() > 1) {
//            log.error("异常：存在规则多个自定义值，应当一个，将会跳过此规则。请尽快排查数据。 ruleId:{} ruleGroup:{} sValues:{}"
//                    , ruleDTO.getId(), sysDprRoleApiRuleGroupDTO, sValues);
//            throw new RuntimeException("异常：存在规则多个自定义值，应当一个，将会跳过此规则。请尽快排查数据，可查看异常日志。");
//        }
//        if (sValues.size() == 0) {
//            log.error("异常：没有找到自定义规则的规则值，将会跳过此规则。请尽快排查数据。 ruleId:{} ruleGroup:{}"
//                    , ruleDTO.getId(), sysDprRoleApiRuleGroupDTO);
//            throw new RuntimeException("异常：没有找到自定义规则的规则值，将会跳过此规则。请尽快排查数据，可查看异常日志。");
//        }
//        ruleDTO.setDprRuleValue(sValues.get(0).getRoleRuleValue());
//    }
//
//
//    /**
//     * &#064;description  规则组校验方法
//     */
//    public static boolean isVerify(SysDprRoleApiRuleGroupRuleCountBean sysDprRoleApiRuleGroupRuleCountBean) {
//        if (sysDprRoleApiRuleGroupRuleCountBean.getDprRuleGroupGroupEnable() == null) {
//            log.warn("没有取到规则组状态，跳过:" + sysDprRoleApiRuleGroupRuleCountBean);
//            return false;
//        }
//        if (!sysDprRoleApiRuleGroupRuleCountBean.getDprRuleGroupGroupEnable()) {
//            log.debug("规则组状态禁用，跳过:" + sysDprRoleApiRuleGroupRuleCountBean);
//            return false;
//        }
//        if (sysDprRoleApiRuleGroupRuleCountBean.getDprRuleGroupRuleCount() == null ||
//                sysDprRoleApiRuleGroupRuleCountBean.getDprRuleGroupRuleCount() == 0) {
//            log.debug("规则组没有规则，跳过:" + sysDprRoleApiRuleGroupRuleCountBean);
//            return false;
//        }
//        return true;
//    }


}
