package com.elitescloud.cloudt.system.rpc.dpr;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import com.elitescloud.cloudt.system.service.PermissionQueryService;
import com.elitescloud.cloudt.system.service.RoleAppApiDataPermissionRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


/**
 * @author : chen
 * <p>
 * 2022-11-24 14:22
 */
@RestController
@RequestMapping(value = RoleAppApiDataPermissionRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
@Slf4j
public class RoleAppApiDataRulePermissionRpcServiceImpl implements RoleAppApiDataPermissionRpcService {

    private PermissionQueryService permissionQueryService;

    @Override
    public ApiResult<SysDprRoleApiRowColumnRuleDTO> getRoleAppApiDataRulePermission() {
        return permissionQueryService.getDataPermissionOfCurrentUser();
    }

    @Override
    public ApiResult<SysDprRoleApiRowColumnRuleDTO> getDataRulePermission() {
        return this.getRoleAppApiDataRulePermission();
    }

    @Autowired
    public void setPermissionQueryService(PermissionQueryService permissionQueryService) {
        this.permissionQueryService = permissionQueryService;
    }
}
