package com.elitescloud.cloudt.system.rpc.dpr.spi;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.rpc.dpr.strategy.DprSysInternallyStrategyFactory;
import com.elitescloud.cloudt.system.rpc.dpr.strategy.IDprSysInternallyStrategy;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;
import com.elitescloud.cloudt.system.spi.DprSysRuleSysInternallyValueSpi;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * @author : chen
 * <p>
 * 2022-12-01 14:44
 */
@Service
@Slf4j
public class DefaultDprSysInternallyEmployeeSpiImpl implements DprSysRuleSysInternallyValueSpi {

    private final DprSysInternallyStrategyFactory dprSysInternallyStrategyFactory;
    public DefaultDprSysInternallyEmployeeSpiImpl(DprSysInternallyStrategyFactory
                                                          dprSysInternallyStrategyFactory) {
        this.dprSysInternallyStrategyFactory = dprSysInternallyStrategyFactory;
    }

    @Override
    public DprRuleValueSysInternallyBo getSysInternallyRuleFieldRuleValue(GeneralUserDetails userInfo,
                                                                          SysDprRoleApiDataRuleListQueryDTO ruleDTO,
                                                                          DprSysInternallyEnum sysInternallyEnum) {
        IDprSysInternallyStrategy strategy = dprSysInternallyStrategyFactory.getStrategy(sysInternallyEnum);
        if(strategy==null) {
            throw new IllegalArgumentException("Unexpected enum constant: " + sysInternallyEnum);
        }
        DprRuleValueSysInternallyBo dprRuleValueSysInternallyBo=
                strategy.calculateRuleValue(userInfo, ruleDTO);

        //如果不是范围的，如果字段有配置，使用配置的字段。
        if (Boolean.FALSE.equals(ruleDTO.getDataRange()) && StringUtils.hasText(ruleDTO.getDprRuleField())) {
            // 自定义规则时
            dprRuleValueSysInternallyBo.setDprRuleField(ruleDTO.getDprRuleField());
            dprRuleValueSysInternallyBo.setDprRuleFieldDeclare("自定义");
        }

        return dprRuleValueSysInternallyBo;
    }



}
