package com.elitescloud.cloudt.system.rpc.dpr.strategy;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;
import org.springframework.util.StringUtils;

import java.util.Collection;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 13:19
 */
public interface IDprSysInternallyStrategy {



    /**
     * 创建用户（BeanSearch）
     */
    public static final String FIELD_CREATE_USER = "createUserId";
    /**
     * 租户（BeanSearch）
     */
    static final String FIELD_TENANT = "tenantId";
    /**
     * 组织（BeanSearch）
     */
    static final String FIELD_ORG = "belongOrgId";
    static final String FIELD_OU = "ou_code";

    DprRuleValueSysInternallyBo calculateRuleValue(GeneralUserDetails userInfo,
                                                   SysDprRoleApiDataRuleListQueryDTO ruleDTO);
    DprSysInternallyEnum getType();
    default String normalizeValue(Collection<?> values) {
        if (CollUtil.isEmpty(values)) {
            // 没有有效值，则返回-1，标识无权限
            return "-1";
        }
        return StringUtils.collectionToDelimitedString(values, ",");
    }
}
