package com.elitescloud.cloudt.system.rpc.dpr.strategy.impl;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleFieldTypeEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysUnderlingDTO;
import com.elitescloud.cloudt.system.rpc.dpr.strategy.IDprSysInternallyStrategy;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 13:23
 */
@Service
@Slf4j
public class DprSysInternallyEmployeeLocalSub implements IDprSysInternallyStrategy {

    @Override
    public DprRuleValueSysInternallyBo calculateRuleValue(GeneralUserDetails userInfo, SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        DprRuleValueSysInternallyBo dprRuleValueSysInternallyBo = new DprRuleValueSysInternallyBo();
        if (userInfo.getUser().getEmployeeId() != null){
            List<Long> employeeIdList = new ArrayList<>(16);
            employeeIdList.add(userInfo.getUser().getEmployeeId());

            // 下属
            if (CollUtil.isNotEmpty(userInfo.getUser().getUnderlingList())) {
                var underlingIdList = userInfo.getUser().getUnderlingList().stream().map(SysUnderlingDTO::getEmployeeId).collect(Collectors.toList());
                employeeIdList.addAll(underlingIdList);
            }
            dprRuleValueSysInternallyBo.setDprRuleValue(normalizeValue(employeeIdList));
            log.info("underling employeeIds:{}", dprRuleValueSysInternallyBo.getDprRuleValue());
        }else{
            log.error("数据权限错误：账号没有员工信息D");
            throw new BusinessException("数据权限错误：账号没有员工信息");
        }
        dprRuleValueSysInternallyBo.setDprRuleValueDeclare( DprSysInternallyEnum.DPR_SYS_INTERNALLY_EMPLOYEE_LOCAL_SUB.getValueDescription());
        dprRuleValueSysInternallyBo.setDprRuleFieldType(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_NUMBER.name());
        dprRuleValueSysInternallyBo.setDprRuleFieldTypeName(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_NUMBER.getValueDescription());



        return dprRuleValueSysInternallyBo;
    }
    @Override
    public DprSysInternallyEnum getType() {
        return DprSysInternallyEnum.DPR_SYS_INTERNALLY_EMPLOYEE_LOCAL_SUB;
    }
}
