package com.elitescloud.cloudt.system.rpc.dpr.strategy.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleFieldTypeEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprSysInternallyEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.rpc.dpr.strategy.IDprSysInternallyStrategy;
import com.elitescloud.cloudt.system.service.EmployeeQueryService;
import com.elitescloud.cloudt.system.service.OrgQueryService;
import com.elitescloud.cloudt.system.service.model.bo.DprRuleValueSysInternallyBo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023-12-22 13:25
 */
@Service
@Slf4j
public class DprSysInternallyOu implements IDprSysInternallyStrategy {

    @Override
    public DprRuleValueSysInternallyBo calculateRuleValue(GeneralUserDetails userInfo, SysDprRoleApiDataRuleListQueryDTO ruleDTO) {
        DprRuleValueSysInternallyBo dprRuleValueSysInternallyBo = new DprRuleValueSysInternallyBo();

        // 所在公司
        dprRuleValueSysInternallyBo.setDprRuleValue(CharSequenceUtil.blankToDefault(userInfo.getUser().getOuCode(), "unknown"));
        dprRuleValueSysInternallyBo.setDprRuleValueDeclare("当前用户公司ID");
        dprRuleValueSysInternallyBo.setDprRuleFieldType(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_TEXT.name());
        dprRuleValueSysInternallyBo.setDprRuleFieldTypeName(DprRuleFieldTypeEnum.DPR_RULE_FIELD_TYPE_TEXT.getValueDescription());


//        dprRuleValueSysInternallyBo.setDprRuleRelation(DprRuleRelationEnum.DPR_RULE_RELATION_AND.name());
//        dprRuleValueSysInternallyBo.setDprRuleRelationName(DprRuleRelationEnum.DPR_RULE_RELATION_AND.getValueDescription());
//        dprRuleValueSysInternallyBo.setDprRuleField(FIELD_OU);
//        dprRuleValueSysInternallyBo.setDprRuleFieldDeclare("数据归属公司code");
//        dprRuleValueSysInternallyBo.setDprRuleCondition(DprRuleConditionEnum.Equal.name());
//        dprRuleValueSysInternallyBo.setDprRuleConditionName(DprRuleConditionEnum.Equal.getValueDescription());
    return dprRuleValueSysInternallyBo;
    }
    @Override
    public DprSysInternallyEnum getType() {
        return DprSysInternallyEnum.DPR_SYS_INTERNALLY_OU;
    }
}
