package com.elitescloud.cloudt.system.rpc.extend;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysAreaNamesQueryDTO;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaNamesRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitescloud.cloudt.system.service.AreaQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 3/3/2023
 */
@RestController
@RequestMapping(value = SysAreaRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysAreaRpcServiceImpl implements SysAreaRpcService {

    private AreaQueryService queryService;

    @Override
    public ApiResult<List<SysAreaRespDTO>> listByAreaCodes(Set<String> areaCodes) {
        return queryService.listByAreaCodes(areaCodes);
    }

    @Override
    public ApiResult<List<SysAreaRespDTO>> listByParentAreaCode(String areaCode) {
        return queryService.listByParentAreaCode(areaCode);
    }

    @Override
    public ApiResult<List<SysAreaRespDTO>> queryList(SysAreaQueryDTO queryDTO) {
        return queryService.queryList(queryDTO);
    }

    @Override
    public ApiResult<List<SysAreaNamesRespDTO>> queryListByNames(SysAreaNamesQueryDTO queryDTO) {
        return queryService.queryListByNames(queryDTO);
    }

    @Autowired
    public void setQueryService(AreaQueryService queryService) {
        this.queryService = queryService;
    }
}
