package com.elitescloud.cloudt.system.rpc.extend;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysCurrencyRateQueryDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRateRpcService;
import com.elitescloud.cloudt.system.service.CurrencyRateQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 3/15/2023
 */
@RestController
@RequestMapping(value = SysCurrencyRateRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysCurrencyRateRpcServiceImpl implements SysCurrencyRateRpcService {

    private CurrencyRateQueryService queryService;

    @Override
    public ApiResult<Double> findRatio(SysCurrencyRateQueryDTO queryDTO) {
        return queryService.findRatio(queryDTO);
    }

    @Autowired
    public void setQueryService(CurrencyRateQueryService queryService) {
        this.queryService = queryService;
    }
}
