package com.elitescloud.cloudt.system.rpc.extend;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysCurrencyQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitescloud.cloudt.system.service.CurrencyQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 3/3/2023
 */
@RestController
@RequestMapping(value = SysCurrencyRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class SysCurrencyRpcServiceImpl implements SysCurrencyRpcService {

    private CurrencyQueryService queryService;

    @Override
    public ApiResult<SysCurrencyRespDTO> getByCode(String currCode) {
        return queryService.getByCode(currCode);
    }

    @Override
    public ApiResult<List<SysCurrencyRespDTO>> listByCodes(Set<String> currCodes) {
        return queryService.listByCodes(currCodes);
    }

    @Override
    public ApiResult<List<SysCurrencyRespDTO>> queryList(SysCurrencyQueryDTO queryDTO) {
        return queryService.queryList(queryDTO);
    }

    @Autowired
    public void setQueryService(CurrencyQueryService queryService) {
        this.queryService = queryService;
    }
}
