package com.elitescloud.cloudt.system.rpc.extend;

import com.elitescloud.boot.mq.config.CloudtMqAutoConfiguration;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.dto.SysMqConsumeResultDTO;
import com.elitescloud.cloudt.system.provider.dto.SysMqMessageStorageDTO;
import com.elitescloud.cloudt.system.provider.dto.SysMqSendResultDTO;
import com.elitescloud.cloudt.system.provider.extend.SysMqMessageRpcService;
import com.elitescloud.cloudt.system.service.SysMqMessageMngService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/16
 */
@RestController
@RequestMapping(value = SysMqMessageRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
@ConditionalOnClass(CloudtMqAutoConfiguration.class)
public class SysMqMessageRpcServiceImpl implements SysMqMessageRpcService {

    private SysMqMessageMngService mngService;

    @Override
    public ApiResult<String> saveMessage(SysMqMessageStorageDTO messageDTO) {
        return mngService.saveMessage(messageDTO);
    }

    @Override
    public ApiResult<String> updateSendResult(SysMqSendResultDTO sendResult) {
        return mngService.updateSendResult(sendResult);
    }

    @Override
    public ApiResult<String> updateConsumeResult(SysMqConsumeResultDTO consumeResult) {
        return mngService.updateConsumeResult(consumeResult);
    }

    @Autowired
    public void setMngService(SysMqMessageMngService mngService) {
        this.mngService = mngService;
    }
}
