package com.elitescloud.cloudt.system.rpc.org;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeePageQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeePageRespDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.service.EmployeeMngService;
import com.elitescloud.cloudt.system.service.EmployeeQueryService;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/12/20
 */
@RestController
@RequestMapping(value = EmployeeRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
@Log4j2
public class EmployeeRpcServiceImpl implements EmployeeRpcService {

    private EmployeeQueryService employeeQueryService;
    private EmployeeMngService employeeMngService;

    @Override
    public ApiResult<String> upsert(EmployeeUpsertDTO upsertDTO) {
        return employeeMngService.upsert(upsertDTO);
    }

    @Override
    public ApiResult<List<String>> upsertBatch(List<EmployeeUpsertDTO> upsertDTOList) {
        List<String> codeList = new ArrayList<>(128);
        for (EmployeeUpsertDTO upsertDTO : upsertDTOList) {
            try {
                var result = employeeMngService.upsert(upsertDTO);
                codeList.add(result.getData());
            } catch (Exception e) {
                log.error("添加员工异常：", e);
                codeList.add(null);
            }
        }
        return ApiResult.ok(codeList);
    }

    @Override
    public ApiResult<List<String>> checkBatch(List<EmployeeUpsertDTO> upsertDTOList) {
        return employeeMngService.checkForUpsert(upsertDTOList);
    }

    @Override
    public ApiResult<String> updateEnabledByCode(String code, Boolean enabled) {
        return employeeMngService.updateEnabledByCode(code, enabled);
    }

    @Override
    public ApiResult<Long> updateMobile(Long id, String mobile, Boolean updateUser) {
        return employeeMngService.updateMobile(id, mobile, updateUser);
    }

    @Override
    public ApiResult<Long> updateEmail(Long id, String email, Boolean updateUser) {
        return employeeMngService.updateEmail(id, email, updateUser);
    }

    @Override
    public ApiResult<SysEmployeeBasicDTO> getById(Long id) {
        return employeeQueryService.getById(id);
    }

    @Override
    public ApiResult<SysEmployeeBasicDTO> getByCode(String code) {
        return employeeQueryService.getByCode(code);
    }

    @Override
    public ApiResult<SysEmployeeBasicDTO> getByUsername(String username) {
        return employeeQueryService.getByUsername(username);
    }

    @Override
    public ApiResult<SysEmployeeBasicDTO> getByUserId(Long userId) {
        return employeeQueryService.getByUserId(userId);
    }

    @Override
    public ApiResult<SysEmployeeDetailDTO> getDetailById(Long id) {
        return employeeQueryService.getDetailById(id);
    }

    @Override
    public ApiResult<SysEmployeeDetailDTO> getDetailByCode(String code) {
        return employeeQueryService.getDetailByCode(code);
    }

    @Override
    public ApiResult<SysEmployeeDetailDTO> getDetailByUserId(Long userId) {
        return employeeQueryService.getDetailByUserId(userId);
    }

    @Override
    public ApiResult<SysEmployeeDetailDTO> getDetailByUsername(String username) {
        return employeeQueryService.getDetailByUsername(username);
    }

    @Override
    public ApiResult<List<SysEmployeeDetailDTO>> getDetailListByCode(Set<String> codes) {
        return employeeQueryService.getDetailListByCode(codes);
    }

    @Override
    public ApiResult<List<EmployeeUnderlingDTO>> getUnderlingByCode(String code, Boolean cascade, Boolean enabled) {
        return employeeQueryService.getUnderlingByCode(code, cascade, enabled);
    }

    @Override
    public ApiResult<List<SysEmployeeBasicDTO>> queryList(EmployeeQueryDTO queryDTO) {
        return employeeQueryService.queryList(queryDTO);
    }

    @Override
    public ApiResult<PagingVO<EmployeePageRespDTO>> queryByPage(EmployeePageQueryDTO queryDTO) {
        return employeeQueryService.queryByPage(queryDTO);
    }

    @Override
    public ApiResult<Boolean> bindSalesman(Long id, String salesmanId) {
        return employeeMngService.bindSalesman(id, salesmanId);
    }

    @Override
    public ApiResult<List<String>> getSalesmanId(Long id) {
        return employeeQueryService.getSalesmanId(id);
    }

    @Override
    public ApiResult<List<String>> getSalesmanIdByUserId(Long userId) {
        return employeeQueryService.getSalesmanIdByUserId(userId);
    }

    @Autowired
    public void setEmployeeQueryService(EmployeeQueryService employeeQueryService) {
        this.employeeQueryService = employeeQueryService;
    }

    @Autowired
    public void setEmployeeMngService(EmployeeMngService employeeMngService) {
        this.employeeMngService = employeeMngService;
    }
}
