package com.elitescloud.cloudt.system.rpc.org;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitescloud.cloudt.system.service.UserMngService;
import com.elitescloud.cloudt.system.service.UserQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/12/27
 */
@RestController
@RequestMapping(value = UserRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
public class UserRpcServiceImpl implements UserRpcService {

    @Autowired
    private UserQueryService userQueryService;
    @Autowired
    private UserMngService userMngService;

    @Override
    public ApiResult<Long> upsert(UserCreateDTO userBasicDTO) {
        return userMngService.save(userBasicDTO);
    }

    @Override
    public ApiResult<Long> updatePwd(Long id, String pwd) {
        return userMngService.updatePassword(id, pwd);
    }

    @Override
    public ApiResult<Long> updateEnabled(Long id, Boolean enabled) {
        return userMngService.updateEnabled(id, enabled);
    }

    @Override
    public ApiResult<Long> delete(Long id) {
        return userMngService.delete(id);
    }

    @Override
    public ApiResult<SysUserBasicDTO> getById(Long id) {
        return userQueryService.getBasicById(id);
    }

    @Override
    public ApiResult<List<SysUserBasicDTO>> getByIds(List<Long> ids) {
        return userQueryService.getBasicById(ids);
    }

    @Override
    public ApiResult<Long> getIdByUsername(String username) {
        return userQueryService.getIdByUsername(username);
    }

    @Override
    public ApiResult<Boolean> existsUsername(String username) {
        return userQueryService.existsUsername(username);
    }

    @Override
    public ApiResult<Boolean> existsMobile(String mobile) {
        return userQueryService.existsMobile(mobile);
    }

    @Override
    public ApiResult<Boolean> existsEmail(String email) {
        return userQueryService.existsEmail(email);
    }

    @Override
    public ApiResult<List<SysUserBasicDTO>> queryUser(UserQueryDTO queryParam) {
        return userQueryService.queryUser(queryParam);
    }

    @Override
    public ApiResult<Long> updateMobile(Long id, String mobile) {
        return userMngService.updateMobile(id, mobile);
    }

    @Override
    public ApiResult<Long> updateEmail(Long id, String email) {
        return userMngService.updateEmail(id, email);
    }
}
