package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysAreaNamesQueryDTO;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaNamesRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonAreaQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonAreaTreeRespVO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 行政区域查询接口.
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/31
 */
public interface AreaQueryService {

    /**
     * 查询行政区域列表
     *
     * @param queryVO 查询参数
     * @return 行政区域列表
     */
    ApiResult<List<CommonAreaTreeRespVO>> listArea(@NotNull CommonAreaQueryVO queryVO);

    /**
     * 根据编码查询名称
     *
     * @param areaCodes 区域编码
     * @return 编码与名称
     */
    ApiResult<Map<String, String>> queryNamesByAreaCode(@NotEmpty Collection<String> areaCodes);

    /**
     * 根据编号查询行政区域
     *
     * @param areaCodes 行政区域编码
     * @return 行政区域列表
     */
    ApiResult<List<SysAreaRespDTO>> listByAreaCodes(@NotEmpty Set<String> areaCodes);

    /**
     * 根据上级行政区域编码查询行政区域
     *
     * @param areaCode 上级行政区域编码
     * @return 行政区域列表
     */
    ApiResult<List<SysAreaRespDTO>> listByParentAreaCode(@NotBlank String areaCode);

    /**
     * 查询行政区域
     *
     * @param queryDTO 查询参数
     * @return 行政区域列表
     */
    ApiResult<List<SysAreaRespDTO>> queryList(@NotNull SysAreaQueryDTO queryDTO);

    /**
     * 判断编码是否存在
     *
     * @param code 编码
     * @return 是否存在
     */
    ApiResult<Boolean> existsCode(@NotBlank String code);

    /**
     * 根据编码或名称组查询
     *
     * @param codeOrNames 编码或名称
     * @return 行政区域对象
     */
    ApiResult<List<SysAreaNamesRespDTO>> queryListByNames(SysAreaNamesQueryDTO queryDTO);
}
