package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.auth.model.OAuthToken;
import com.elitescloud.cloudt.common.base.ApiResult;

import javax.validation.constraints.NotBlank;

/**
 * 账号认证授权服务.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/16
 */
public interface AuthUserService {

    /**
     * 根据用户ID进行认证授权
     *
     * @param userIdCypher 用户ID（加密后的字符串）
     * @return token
     */
    ApiResult<OAuthToken> authByUserId(@NotBlank String userIdCypher);
}
