package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysCurrencyQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/31
 */
public interface CurrencyQueryService {

    /**
     * 查询所有货币
     *
     * @return 货币列表
     */
    ApiResult<List<CodeNameParam>> listCurrency();

    /**
     * 根据币种编码获取币种信息
     *
     * @param currCode 币种编码
     * @return 币种信息
     */
    ApiResult<SysCurrencyRespDTO> getByCode(@NotBlank String currCode);

    /**
     * 根据编码查询币种
     *
     * @param currCodes 币种编码
     * @return 币种信息列表
     */
    ApiResult<List<SysCurrencyRespDTO>> listByCodes(@NotEmpty Set<String> currCodes);

    /**
     * 查询币种
     *
     * @param queryDTO 查询参数
     * @return 币种信息列表
     */
    ApiResult<List<SysCurrencyRespDTO>> queryList(@NotNull SysCurrencyQueryDTO queryDTO);
}
