package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
public interface EmpGroupQueryService {

    /**
     * 根据员工组编号查询用户ID
     *
     * @param groupCode 员工组编号
     * @return 用户ID
     */
    ApiResult<List<Long>> getUserIdsByGroupCode(@NotBlank String groupCode);


    /**
     * 根据员工组编号查询用户ID
     *
     * @param groupCodes 员工组编号
     * @return 员工组件与用户ID的map
     */
    ApiResult<Map<String, List<Long>>> queryUserIdsByGroupCodes(@NotEmpty Set<String> groupCodes);
}
