package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.menu.MenuFavorPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.MenuFavorRespVO;
import com.elitescloud.cloudt.system.model.vo.save.menu.MenuFavorSaveVO;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/31
 */
public interface MenuFavorMngService {

    /**
     * 保存收藏菜单
     *
     * @param saveVO 菜单信息
     * @return 保存结果
     */
    ApiResult<Long> upsert(MenuFavorSaveVO saveVO);

    /**
     * 删除收藏菜单
     *
     * @param id 收藏ID
     * @return 收藏ID
     */
    ApiResult<Long> delete(Long id);

    /**
     * 切换启用状态
     *
     * @param id 收藏ID
     * @return 收藏ID
     */
    ApiResult<Long> switchEnabled(Long id);

    /**
     * 获取详情
     *
     * @param id ID
     * @return 详情
     */
    ApiResult<MenuFavorRespVO> get(Long id);

    /**
     * 分页查询收藏菜单
     *
     * @param queryVO 查询参数
     * @return 菜单列表
     */
    ApiResult<PagingVO<MenuFavorRespVO>> pageMng(MenuFavorPageQueryVO queryVO);
}
