package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.menu.MenuTreeCustomRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.MenuTreeRespVO;
import com.elitescloud.cloudt.system.model.vo.save.menu.MenuTreeSaveVO;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/13
 */
public interface MenuMngService {

    /**
     * 保存自定义菜单树
     * @param saveVOList
     * @return
     */
    ApiResult<Boolean> saveTree(List<MenuTreeSaveVO> saveVOList);

    /**
     * 更新启用状态
     *
     * @return 更新结果
     */
    ApiResult<Boolean> updateEnabled();

    /**
     * 获取默认菜单树
     *
     * @param tree 菜单树
     * @return 菜单树
     */
    ApiResult<List<MenuTreeRespVO>> getTreeDefault(Boolean tree);

    /**
     * 获取自定义菜单树
     *
     * @param tree 菜单树
     * @return 菜单树
     */
    ApiResult<List<MenuTreeCustomRespVO>> getTreeCustom(Boolean tree);

    /**
     * 获取启用状态
     *
     * @return 启用状态
     */
    ApiResult<Boolean> getEnabled();
}
