package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.req.OrgUpsertDTO;
import com.elitescloud.cloudt.system.model.vo.query.org.OrgPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OrgDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OrgPagedRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OrgTreeNodeRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.OrgSaveVO;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/9/29
 */
public interface OrgMngService {

    /**
     * 保存组织信息
     *
     * @param saveVO 组织信息
     * @return 组织ID
     */
    ApiResult<Long> upsert(OrgSaveVO saveVO);

    /**
     * 保存组织
     * <p>
     * 如果id不为空，则是修改
     *
     * @param upsertDTO 组织信息
     * @return 组织ID
     */
    ApiResult<Long> upsert(OrgUpsertDTO upsertDTO);

    /**
     * 删除数据
     *
     * @param id 数据ID
     * @return 删除结果
     */
    ApiResult<Long> delete(Long id);

    /**
     * 切换组织启用状态
     *
     * @param id 组织ID
     * @return 组织ID
     */
    ApiResult<Long> updateEnabled(Long id);

    /**
     * 修改启用状态
     *
     * @param id      组织ID
     * @param enabled 启用状态
     * @return 组织ID
     */
    ApiResult<Long> updateEnabled(Long id, Boolean enabled);

    /**
     * 重构行政组织域树
     *
     * @param rootOrgId 根节点ID
     * @return 结果
     */
    ApiResult<Boolean> updateTreeRebuild(Long rootOrgId);

    /**
     * 获取组织树
     * <p>
     * 包含已禁用的
     *
     * @param tree 是否转为树形
     * @return 组织树
     */
    ApiResult<List<OrgTreeNodeRespVO>> getOrgTree(Boolean tree);

    /**
     * 获取组织节点详情
     *
     * @param id             组织ID
     * @param withParentType 指定的上级类型
     * @return 组织信息
     */
    ApiResult<OrgDetailRespVO> getDetail(@NotNull Long id, String withParentType);

    /**
     * 分页查询组织
     *
     * @param queryVO 查询参数
     * @return 组织列表
     */
    ApiResult<PagingVO<OrgPagedRespVO>> queryByPage(OrgPageQueryVO queryVO);
}
