package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.org.OuPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OuDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.OuPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.OuSaveVO;

/**
 * 公司管理.
 *
 * @author Kaiser（wang shao）
 * @date 2023/2/1
 */
public interface OuMngService {

    /**
     * 保存公司
     *
     * @param saveVO 公司信息
     * @return 公司ID
     */
    ApiResult<Long> save(OuSaveVO saveVO);

    /**
     * 删除公司信息
     *
     * @param id 公司ID
     * @return 公司ID
     */
    ApiResult<Long> delete(Long id);

    /**
     * 切换启用禁用
     *
     * @param id 公司ID
     * @return 切换结果
     */
    ApiResult<Long> updateEnabled(Long id);

    /**
     * 分页查询公司
     *
     * @param queryVO 查询参数
     * @return 公司列表
     */
    ApiResult<PagingVO<OuPageRespVO>> page(OuPageQueryVO queryVO);

    /**
     * 获取公司详情
     *
     * @param id 公司ID
     * @return 公司详情
     */
    ApiResult<OuDetailRespVO> get(Long id);
}
