package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.UserRoleSaveDTO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.SysDprBatchSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.SysDprSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.MenuApiSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleAppPermissionSaveVO;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 权限管理.
 *
 * @author Kaiser（wang shao）
 * @date 2/23/2023
 */
public interface PermissionMngService {

    /**
     * 保存用户角色
     *
     * @param userId  用户ID
     * @param roleIds 角色ID
     * @return 用户ID
     */
    ApiResult<Long> saveUserRoles(@NotNull Long userId, List<Long> roleIds);

    /**
     * 批量保存用户角色
     *
     * @param saveDTOList 保存信息
     * @return 用户ID
     */
    ApiResult<List<Long>> saveUserRoles(@NotNull List<UserRoleSaveDTO> saveDTOList);

    /**
     * 保存角色的权限菜单
     *
     * @param roleId     角色ID
     * @param saveVOList 权限信息
     * @return 角色ID
     */
    ApiResult<Long> savePermissionMenu(@NotNull Long roleId, List<RoleAppPermissionSaveVO> saveVOList);

    /**
     * 保存数据权限
     *
     * @param saveVO 保存信息
     * @return 角色ID
     */
    ApiResult<Long> saveApiDataPermission(SysDprSaveVO saveVO);

    /**
     * 保存批量数据权限
     *
     * @param saveVO 保存信息
     * @return 保存结果
     */
    ApiResult<Boolean> saveApiDataPermission(SysDprBatchSaveVO saveVO);

    /**
     * 保存菜单挂载的API
     *
     * @param saveVO 菜单API
     * @return 结果
     */
    ApiResult<Boolean> saveMenuApi(MenuApiSaveVO saveVO);
}
