package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.role.RoleGroupPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RoleGroupDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RoleGroupPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.role.RoleGroupSaveVO;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/11/24
 */
public interface RoleGroupMngService {

    /**
     * 保存角色组
     *
     * @param saveVO 角色组信息
     * @return 角色组ID
     */
    ApiResult<Long> upsert(RoleGroupSaveVO saveVO);

    /**
     * 删除角色组
     *
     * @param id 角色组ID
     * @return 删除结果
     */
    ApiResult<Long> delete(Long id);

    /**
     * 修改启用状态
     *
     * @param id      角色组ID
     * @param enabled 启用状态
     * @return 角色组ID
     */
    ApiResult<Long> updateEnabled(Long id, Boolean enabled);

    /**
     * 获取角色组详细信息
     *
     * @param id 角色组ID
     * @return 角色组详细信息
     */
    ApiResult<RoleGroupDetailRespVO> getDetail(Long id);

    /**
     * 分页查询分组信息
     *
     * @param queryVO 查询参数
     * @return 分组列表
     */
    ApiResult<PagingVO<RoleGroupPageRespVO>> pageMng(RoleGroupPageQueryVO queryVO);
}
