package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;

import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Set;

/**
 * 角色查询服务.
 *
 * @author Kaiser（wang shao）
 * @date 2/17/2023
 */
public interface RoleQueryService {

    /**
     * 查询角色列表
     *
     * @param businessKey 业务标识
     * @param roleName    角色名称
     * @return 角色列表
     */
    ApiResult<List<IdCodeNameParam>> listRole(String businessKey, String roleName);

    /**
     * 根据角色编码获取角色ID
     *
     * @param roleCode 角色编码
     * @return 角色ID
     */
    ApiResult<Long> getIdByCode(@NotBlank String roleCode);

    /**
     * 根据ID查询角色编码名称
     *
     * @param ids 角色ID
     * @return
     */
    ApiResult<List<IdCodeNameParam>> listCodeNamesById(Set<Long> ids);

    /**
     * 根据编码查询角色编码名称
     *
     * @param codes 角色编码
     * @return
     */
    ApiResult<List<IdCodeNameParam>> listCodeNamesByCode(Set<String> codes);

    /**
     * 获取角色组列表
     *
     * @return 角色组列表
     */
    ApiResult<List<IdCodeNameParam>> listAllRoleGroup();
}
