package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.resp.extend.AlertRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.AlertSaveVO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 系统预警管理服务.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/26
 */
public interface SysAlertMngService {

    /**
     * 保存警告配置
     *
     * @param saveVO 配置信息
     * @return 结果
     */
    ApiResult<Long> saveAlert(@NotNull AlertSaveVO saveVO);

    /**
     * 获取预警配置
     *
     * @param businessType 业务类型
     * @return 配置
     */
    ApiResult<AlertRespVO> getAlert(@NotBlank String businessType);

    /**
     * 获取模板参数列表
     *
     * @param businessType 业务类型
     * @return 参数列表
     */
    ApiResult<List<CodeNameParam>> getTmplParam(@NotBlank String businessType);
}
