package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.mq.common.model.RetryMessageDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.provider.dto.SysMqConsumeResultDTO;
import com.elitescloud.cloudt.system.provider.dto.SysMqMessageStorageDTO;
import com.elitescloud.cloudt.system.provider.dto.SysMqSendResultDTO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * MQ消息服务.
 *
 * @author Kaiser（wang shao）
 * @date 2023/8/16
 */
public interface SysMqMessageMngService {

    /**
     * 保存消息
     *
     * @param messageDTO 消息信息
     * @return 消息ID
     */
    ApiResult<String> saveMessage(SysMqMessageStorageDTO messageDTO);

    /**
     * 更新消息结果
     *
     * @param sendResult 发送结果
     * @return 消息ID
     */
    ApiResult<String> updateSendResult(SysMqSendResultDTO sendResult);

    /**
     * 更新消息发送结果
     *
     * @param consumeResult 消费结果
     * @return 消息ID
     */
    ApiResult<String> updateConsumeResult(SysMqConsumeResultDTO consumeResult);

    /**
     * 删除重试消息
     *
     * @param messageId 消息ID
     * @param reason    删除原因
     * @return 删除结果
     */
    ApiResult<Boolean> deleteRetryMessage(@NotBlank String messageId, String reason);

    /**
     * 尝试发送消息
     *
     * @param messageId 消息ID
     * @param version   消息版本
     * @return 是否可发送
     */
    ApiResult<Boolean> trySend(@NotBlank String messageId, Integer version);

    /**
     * 查询待重试的消息
     *
     * @param lastMessageId 上条消息的ID
     * @param size          获取消息数量
     * @return 消息列表
     */
    ApiResult<List<RetryMessageDTO>> queryRetryMessage(String lastMessageId, int size);
}
