package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysPageFieldConfigDtlParam;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysPageFieldConfigDtlQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysPageFieldConfigQueryVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.SysPageFieldConfigSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.SysPageFieldConfigUpdateVO;
import com.elitescloud.cloudt.system.provider.imports.param.PageFieldImportBO;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/9/8 13:01
 */
public interface SysPageFieldConfigService {
    ApiResult<String> savePageFieldConfig(SysPageFieldConfigSaveVO saveVO);
    ApiResult<Boolean> updatePageFieldConfig(Long id, SysPageFieldConfigUpdateVO updateVO);

    /**
     * 保存导入记录
     *
     * @param importBO 导入信息
     * @return 记录ID
     */
    ApiResult<Long> save(PageFieldImportBO importBO);

    ApiResult<PagingVO<SysPageFieldConfigDtlQueryVO>> queryPageFieldConfigDtl(SysPageFieldConfigDtlParam param);
    ApiResult<SysPageFieldConfigQueryVO> getPageFieldConfig(String configCode);
    ApiResult<Boolean> deletePageFieldConfig(Long id);
    ApiResult<Boolean> deletePageFieldConfigDtl(Long id);
}
