package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.model.vo.save.devops.ExportBasicDataSaveVO;
import org.springframework.http.ResponseEntity;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

/**
 * 系统数据服务.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/8
 */
public interface SystemDataService {

    /**
     * 导出系统数据
     *
     * @return 文件流
     */
    ApiResult<Long> exportData(ExportBasicDataSaveVO saveVO);

    /**
     * 导入数据
     *
     * @param file        文件
     * @param incremental 是否是增量更新
     * @return 导入结果
     */
    ApiResult<Boolean> importData(MultipartFile file, Boolean incremental);
}
