package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.CommonTenantAppVO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonAppPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonAreaQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.CurrencyRateQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonAreaTreeRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonTaxRateRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.system.PwdStrategyRespVO;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/11
 */
public interface SystemQueryService {

    /**
     * 查询应用列表
     *
     * @return 应用列表
     */
    ApiResult<List<CommonTenantAppVO>> listApp();

    /**
     * 分页查询应用
     *
     * @param queryVO 查询参数
     * @return 应用列表
     */
    ApiResult<PagingVO<CommonTenantAppVO>> pageApp(CommonAppPageQueryVO queryVO);

    /**
     * 查询行政区域列表
     *
     * @param queryVO 查询参数
     * @return 行政区域列表
     */
    ApiResult<List<CommonAreaTreeRespVO>> listArea(CommonAreaQueryVO queryVO);

    /**
     * 查询货币列表
     *
     * @return 货币列表
     */
    ApiResult<List<CodeNameParam>> listCurrency();

    /**
     * 查询税率列表
     *
     * @param taxRateNo   税率编码
     * @param taxRateType 税率类型
     * @return 税率列表
     */
    ApiResult<List<CommonTaxRateRespVO>> listTaxRate(String taxRateNo, String taxRateType);

    /**
     * 查询汇率
     *
     * @param queryVO 查询参数
     * @return 汇率
     */
    ApiResult<Double> queryCurrentRate(CurrencyRateQueryVO queryVO);

    /**
     * 获取开户（修改）密码时的密码策略
     *
     * @return 密码策略列表
     */
    ApiResult<List<PwdStrategyRespVO>> listPwdStrategyForCreateAccount();
}
