package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysTaxRateQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysTaxRateRespDTO;
import com.elitescloud.cloudt.system.model.vo.resp.common.CommonTaxRateRespVO;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 3/7/2023
 */
public interface TaxRateQueryService {

    /**
     * 查询税率信息
     *
     * @return 税率列表
     */
    ApiResult<List<CommonTaxRateRespVO>> queryList(String taxRateNo, String taxRateType);

    /**
     * 根据税率编码获取税率信息
     *
     * @param taxRateNo 税率编码
     * @return 税率信息
     */
    ApiResult<SysTaxRateRespDTO> getByTaxRateNo(@NotBlank String taxRateNo);

    /**
     * 根据税率编码获取税率信息
     *
     * @param taxRateNo   税率编码
     * @param taxRateType 税率类型
     * @return 税率信息
     */
    ApiResult<SysTaxRateRespDTO> getByTaxRateNo(@NotBlank String taxRateNo, String taxRateType);

    /**
     * 税率查询
     *
     * @param queryDTO 查询参数
     * @return 税率列表
     */
    ApiResult<List<SysTaxRateRespDTO>> queryList(SysTaxRateQueryDTO queryDTO);
}
