package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.org.TenantOrgPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.TenantOrgDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.TenantOrgRespVO;
import com.elitescloud.cloudt.system.model.vo.save.org.OrgTenantSaveVO;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/9/30
 */
public interface TenantOrgMngService {

    /**
     * 保存租户组织
     *
     * @param saveVO 租户组织信息
     * @return 保存结果
     */
    ApiResult<Long> saveTenantOrg(OrgTenantSaveVO saveVO);

    /**
     * 删除记录
     *
     * @param id 记录ID
     * @return 删除结果
     */
    ApiResult<Long> delete(Long id);

    /**
     * 切换启用禁用
     *
     * @param id 记录ID
     * @return 结果
     */
    ApiResult<Long> updateEnabled(Long id);

    /**
     * 更新管理员
     *
     * @param id      记录ID
     * @param adminId 管理员ID
     * @return 更新结果
     */
    ApiResult<Long> updateAdmin(Long id, Long adminId);

    /**
     * 获取详细信息
     *
     * @param id 记录ID
     * @return 详细信息
     */
    ApiResult<TenantOrgDetailRespVO> getDetail(Long id);

    /**
     * 获取所有的租户组织
     *
     * @return 租户组织列表
     */
    ApiResult<List<TenantOrgRespVO>> getList();

    /**
     * 分页查询租户组织
     *
     * @param queryVO 查询参数
     * @return 租户组织列表
     */
    ApiResult<PagingVO<TenantOrgRespVO>> pageQuery(TenantOrgPageQueryVO queryVO);
}
