package com.elitescloud.cloudt.system.service;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.ThirdApiLogDTO;
import com.elitescloud.cloudt.system.dto.req.ThirdApiLogQueryDTO;
import com.elitescloud.cloudt.system.model.vo.query.extend.ThirdApiLogQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.ThirdApiLogSaveVO;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2023/9/4
 */
public interface ThirdApiLogService {

    /**
     * 保存日志
     *
     * @param logDTO 日志信息
     * @return 日志ID
     */
    ApiResult<Long> saveLog(ThirdApiLogDTO logDTO);

    /**
     * 保存日志
     *
     * @param saveVO    保存
     * @param retrySend 是否重试发送
     * @return 记录ID
     */
    ApiResult<Long> saveLog(ThirdApiLogSaveVO saveVO, boolean retrySend);

    /**
     * 分页查询日志
     *
     * @param requestDTO 查询参数
     * @return 日志列表
     */
    ApiResult<PagingVO<ThirdApiLogDTO>> queryByPage(ThirdApiLogQueryDTO requestDTO);

    /**
     * 分页查询日志
     *
     * @param queryVO 查询参数
     * @return 日志列表
     */
    ApiResult<PagingVO<ThirdApiLogPageRespVO>> queryByPage(ThirdApiLogQueryVO queryVO);

    /**
     * 查询重试记录列表
     *
     * @param originalId 原始ID
     * @return 重试记录列表
     */
    ApiResult<List<ThirdApiLogPageRespVO>> listRetryRecord(Long originalId);

    /**
     * 获取详细信息
     *
     * @param id 记录ID
     * @return 详细信息
     */
    ApiResult<ThirdApiLogDetailRespVO> getDetail(Long id);

    /**
     * 获取所有的业务类型
     *
     * @return 业务类型列表
     */
    ApiResult<List<CodeNameParam>> listBusinessTypes();

    /**
     * 获取所有的目标系统
     *
     * @return 业务类型列表
     */
    ApiResult<List<CodeNameParam>> listTargetSystems();

    /**
     * 获取所有的源系统
     *
     * @return 业务类型列表
     */
    ApiResult<List<CodeNameParam>> listSourceSystems();

    /**
     * 尝试判断是否可以发送
     *
     * @param id
     * @param version
     * @return
     */
    ApiResult<Boolean> trySend(Long id, Integer version);

    /**
     * 删除重试记录
     *
     * @param id
     * @param reason
     * @return
     */
    ApiResult<Boolean> deleteRetry(Long id, String reason);

    /**
     * 更新重试结果
     *
     * @param id
     * @param success
     * @param reason
     */
    ApiResult<Boolean> updateRetryResult(Long id, boolean success, String reason);

    /**
     * 更新响应结果
     *
     * @param id
     * @param manual
     * @param success
     * @param reason
     * @param respBody
     * @return
     */
    ApiResult<Boolean> updateRetryRespResult(Long id, boolean manual, boolean success, String reason, String respBody);
}
