package com.elitescloud.cloudt.system.service;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.elitescloud.boot.excel.common.param.ImportRecordDTO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.elitescloud.cloudt.system.dto.req.RecordResultSaveDTO;
import com.elitescloud.cloudt.system.model.vo.query.extend.TmplImportQueryParam;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplImportRecordRespVO;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/5/31
 */
public interface TmplImportRecordService {

    /**
     * 保存导入记录
     *
     * @param tmplCode   模板编号
     * @param fileCode   数据文件编码
     * @param queryParam 查询参数
     * @return 记录ID
     */
    ApiResult<Long> saveImportRecord(String tmplCode, String fileCode, Map<String, Object> queryParam);

    /**
     * 更新导入记录的总数量
     *
     * @param id       记录ID
     * @param numTotal 导入总数量
     * @return 记录ID
     */
    ApiResult<Long> updateRecordTotal(Long id, Long numTotal);

    /**
     * 更新导入结果
     *
     * @param resultSaveDTO 结果
     * @return 记录ID
     */
    ApiResult<Long> updateImportResult(RecordResultSaveDTO resultSaveDTO);

    /**
     * 保存导出文件
     *
     * @param id       记录ID
     * @param fileCode 文件编码
     * @param order    顺序
     * @return 记录ID
     */
    ApiResult<Long> saveExportFile(Long id, String fileCode, Integer order);

    /**
     * 保存失败记录文件
     *
     * @param recordId     导入记录ID
     * @param failFileCode 失败记录文件编码
     * @return 导入记录ID
     */
    ApiResult<Long> saveImportFailRecord(@NotNull Long recordId, @NotBlank String failFileCode);

    /**
     * 获取进度
     *
     * @param id 记录id
     * @return 进度
     */
    ApiResult<SysImportRateDTO> getImportRateDto(Long id);

    /**
     * 获取记录的文件标识
     *
     * @param id 记录id
     * @return 文件唯一标识
     */
    ApiResult<String> getFileCode(Long id);

    /**
     * 获取未导入结束的
     *
     * @return 记录id
     */
    ApiResult<List<Long>> queryUnFinished(String appCode);

    /**
     * 更新系统异常导致的记录结果
     *
     * @param appCode 应用编码
     * @param failMsg 异常信息
     * @return 更新结果
     */
    ApiResult<Boolean> updateResultForSysError(@NotBlank String appCode, String failMsg);

    /**
     * 分页查询导入记录
     *
     * @param tmplId     模板ID
     * @param queryParam 查询参数
     * @return 导入记录
     */
    ApiResult<PagingVO<TmplImportRecordRespVO>> searchImport(Long tmplId, TmplImportQueryParam queryParam);

    /**
     * 获取导出记录的文件列表
     *
     * @param recordId 记录ID
     * @return 文件列表
     */
    ApiResult<List<FileObjRespVO<String>>> listFileOfExport(Long recordId);

    /**
     * 查询记录
     *
     * @param tmplCode 模板编码
     * @param hours    小时数，默认72小时
     * @param self     是否只查自己的，默认是
     * @return 记录列表
     */
    ApiResult<List<ImportRecordDTO>> queryRecord(@NotBlank String tmplCode, Integer hours, Boolean self);
}
