package com.elitescloud.cloudt.system.service;

import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.elitescloud.boot.common.param.FileInfoVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.TmplQueryParam;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplEditRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplPageMngRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.TmplSaveVO;
import org.springframework.http.HttpEntity;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/5/31
 */
public interface TmplMngService {

    /**
     * 上传模板文件
     *
     * @param file 模板文件
     * @return 模板文件
     */
    ApiResult<FileInfoVO> uploadTmpl(MultipartFile file);

    /**
     * 保存模板信息
     *
     * @param saveVO 保存信息
     * @return 模板ID
     */
    ApiResult<Long> save(TmplSaveVO saveVO);

    /**
     * 更新模板
     *
     * @param id     模板ID
     * @param saveVO 保存信息
     * @return 模板ID
     */
    ApiResult<Long> update(Long id, TmplSaveVO saveVO);

    /**
     * 启用、停用模板
     * <p>
     * 自动切换状态， 如果当前是启用，则改为停用，如果是停用，则改为启用
     *
     * @param id 模板ID
     * @return 模板ID
     */
    ApiResult<Long> updateEnabled(Long id);

    /**
     * 删除模板信息
     *
     * @param id 模板ID
     * @return 模板ID
     */
    ApiResult<Long> delete(Long id);

    /**
     * 删除模板文件
     *
     * @param fileCode 模板文件的唯一标识
     * @return 模板文件的唯一标识
     */
    ApiResult<String> deleteTmplFile(String fileCode);

    /**
     * 获取模板详细信息
     *
     * @param id 模板ID
     * @return 模板信息
     */
    ApiResult<TmplEditRespVO> get(Long id);

    /**
     * 下载模板
     *
     * @param id 模板ID
     * @return 模板文件
     */
    HttpEntity<StreamingResponseBody> download(Long id);

    /**
     * 下载模板
     *
     * @param fileCode 模板文件的唯一标识
     * @return 模板文件
     */
    HttpEntity<StreamingResponseBody> downloadByFileCode(String fileCode);

    /**
     * 下载模板
     *
     * @param code 模板编码
     * @return 模板文件
     */
    HttpEntity<StreamingResponseBody> downloadByCode(String code);

    /**
     * 搜索模板
     *
     * @param queryParam 查询参数
     * @return 模板信息
     */
    ApiResult<PagingVO<TmplPageMngRespVO>> search(TmplQueryParam queryParam);
}
