package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.udc.UdcPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.udc.UdcSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.udc.UdcValueSaveVO;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/11
 */
public interface UdcMngService {

    /**
     * 保存UDC
     *
     * @param saveVO 保存参数
     * @return 保存结果
     */
    ApiResult<Long> save(UdcSaveVO saveVO);

    /**
     * 保存UDC值
     *
     * @param id     UDC ID
     * @param saveVO 值信息
     * @return UDC值ID
     */
    ApiResult<Long> saveValue(Long id, UdcValueSaveVO saveVO);

    /**
     * 切换值的启用状态
     *
     * @param valueId 值ID
     * @return 值ID
     */
    ApiResult<Long> updateValueEnabled(Long valueId);

    /**
     * 删除值
     *
     * @param valueId 值ID
     * @return 值ID
     */
    ApiResult<Long> deleteValue(Long valueId);

    /**
     * 分页查询UDC
     *
     * @param queryVO 查询参数
     * @return UDC列表
     */
    ApiResult<PagingVO<UdcPageRespVO>> page(UdcPageQueryVO queryVO);

    /**
     * 查看UDC详情
     *
     * @param id ID
     * @return 详情
     */
    ApiResult<UdcDetailRespVO> detail(Long id);
}
