package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import lombok.extern.slf4j.Slf4j;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 消息模板.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/8
 */
@Slf4j
public class MsgTemplateInitProvider extends AbstractBasicDataInitProvider {

    @Override
    public String typeName() {
        return "消息模板";
    }

    @Override
    public String tableName() {
        return "sys_msg_template";
    }

    @Override
    public List<String> fields() {
        return List.of("template_code", "template_name", "template_group", "template_describe",
                "create_time", "modify_time");
    }

    @Override
    public Map<String, String> fieldTitles() {
        Map<String, String> titles = new LinkedHashMap<>(16);
        titles.put("id", "ID");
        titles.put("template_code", "编码");
        titles.put("template_name", "名称");
        titles.put("template_group", "分组");
        titles.put("template_describe", "描述");
        titles.put("create_time", "创建时间");
        titles.put("modify_time", "最后修改时间");
        return titles;
    }

    @Override
    public boolean isTenantData() {
        return true;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc("create_time"));
    }

    @Override
    public UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        var tmpl_code = this.getStringValue(data, "template_code", null);
        Assert.notBlank(tmpl_code, "模板编码为空");

        data.put("original_id", data.get("id"));

        if (currentData.isEmpty()) {
            return UpdateType.ADD;
        }

        var id = currentData.stream()
                .filter(t -> tmpl_code.equals(t.get("template_code")))
                .findFirst()
                .map(t -> t.get("id"))
                .orElse(null);
        data.put("id", id);
        return id == null ? UpdateType.ADD : UpdateType.UPDATE;
    }
}
