package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.platform.model.constant.PlatformAdminTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppTypeEnum;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 管理员权限菜单.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/8
 */
public class PlatformAdminMenusInitProvider extends AbstractBasicDataInitProvider {

    @Override
    public String typeName() {
        return "管理员权限菜单";
    }

    @Override
    public String tableName() {
        return "sys_platform_admin_menus";
    }

    @Override
    public List<String> fields() {
        return List.of("create_time", "admin_type", "menus_code");
    }

    @Override
    public Map<String, String> fieldTitles() {
        Map<String, String> titles = new LinkedHashMap<>(16);
        titles.put("admin_type", "管理员类型");
        titles.put("admin_type_name", "管理员类型名称");
        titles.put("menus_code", "菜单编码");
        titles.put("create_time", "创建时间");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc("admin_type"), OrderItem.desc("create_time"));
    }

    @Override
    public Map<String, Object> convertForExport(Map<String, Object> data, List<Map<String, Object>> preData) {
        // 转换类型
        var type = PlatformAdminTypeEnum.parse(ObjectUtil.defaultIfNull(data.get("admin_type"), "").toString());
        if (type != null) {
            data.put("admin_type_name", type.getDescription());
        }
        return data;
    }

    @Override
    public UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        var admin_type = this.getStringValue(data, "admin_type", null);
        Assert.notBlank(admin_type, "管理员类型为空");
        var menus_code = this.getStringValue(data, "menus_code", null);
        Assert.notBlank(menus_code, "菜单编码为空");

        if (currentData.isEmpty()) {
            return UpdateType.ADD;
        }

        var id = currentData.parallelStream()
                .filter(t -> menus_code.equals(t.get("menus_code")) && admin_type.equals(t.get("admin_type")))
                .findFirst()
                .map(t -> t.get("id"))
                .orElse(null);
        data.put("id", id);
        return id == null ? UpdateType.ADD : UpdateType.UPDATE;
    }
}
