package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.cloudt.common.base.param.OrderItem;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 货币.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/8
 */
public class PlatformCurrencyInitProvider extends AbstractBasicDataInitProvider {

    @Override
    public String typeName() {
        return "货币";
    }

    @Override
    public String tableName() {
        return "sys_platform_currency";
    }

    @Override
    public List<String> fields() {
        return List.of("curr_code", "curr_name", "disp_decimal", "enabled", "create_time", "modify_time");
    }

    @Override
    public Map<String, String> fieldTitles() {
        Map<String, String> titles = new LinkedHashMap<>(16);
        titles.put("curr_code", "货币编码");
        titles.put("curr_name", "货币名称");
        titles.put("disp_decimal", "小数位数");
        titles.put("enabled", "状态");
        titles.put("create_time", "创建时间");
        titles.put("modify_time", "最后修改时间");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc("create_time"));
    }

    @Override
    public Map<String, Object> convertForExport(Map<String, Object> data, List<Map<String, Object>> preData) {
        // 过滤启用的数据
        var enabled = getBooleanValue(data.get("enabled"), null);
        if (enabled == null || !enabled) {
            return null;
        }

        return data;
    }

    @Override
    public UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        var curr_code = this.getStringValue(data, "curr_code", null);
        Assert.notBlank(curr_code, "货币编码为空");

        this.normalizeBooleanValue(data, "enabled");

        if (currentData.isEmpty()) {
            return UpdateType.ADD;
        }

        var existsData = currentData.parallelStream()
                .filter(t -> curr_code.equals(t.get("curr_code")))
                .findFirst()
                .orElse(null);
        if (existsData == null) {
            this.normalizeForAdd(data);
            return UpdateType.ADD;
        }
        this.normalizeForUpdate(data, existsData);
        return UpdateType.UPDATE;
    }

    private void normalizeForAdd(Map<String, Object> data) {
        data.put("enabled", this.getBooleanValue(data.get("enabled"), true));
    }

    private void normalizeForUpdate(Map<String, Object> data, Map<String, Object> dataExists) {
        data.put("id", dataExists.get("id"));
        data.put("enabled", ObjectUtil.defaultIfNull(dataExists.get("enabled"), this.getBooleanValue(data.get("enabled"), true)));
    }
}
