package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.param.OrderItem;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 发号规则.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/8
 */
public class PlatformNumberRuleInitProvider extends AbstractBasicDataInitProvider {

    @Override
    public String typeName() {
        return "发号规则";
    }

    @Override
    public String tableName() {
        return "sys_platform_number_rule";
    }

    @Override
    public List<String> fields() {
        return List.of("id", "create_time", "modify_time", "app_code", "rule_code", "rule_name", "sample_code",
                "enabled");
    }

    @Override
    public Map<String, String> fieldTitles() {
        Map<String, String> titles = new LinkedHashMap<>(16);
        titles.put("id", "ID");
        titles.put("app_code", "应用编码");
        titles.put("rule_code", "规则编码");
        titles.put("rule_name", "名称");
        titles.put("sample_code", "示例");
        titles.put("enabled", "状态");
        titles.put("create_time", "创建时间");
        titles.put("modify_time", "最后修改时间");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.asc("app_code"), OrderItem.desc("create_time"));
    }

    @Override
    public Map<String, Object> convertForExport(Map<String, Object> data, List<Map<String, Object>> preData) {
        // 过滤启用的数据
        var enabled = getBooleanValue(data.get("enabled"), null);
        if (enabled == null || !enabled) {
            return null;
        }

        return data;
    }

    @Override
    public UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        var rule_code = this.getStringValue(data, "rule_code", null);
        Assert.notBlank(rule_code, "发号规则编码为空");
        var id = this.getLongValue(data, "id", null);
        Assert.notNull(id, "发号规则ID为空");
        this.normalizeBooleanValue(data, "enabled");

        data.put("original_id", id);
        if (currentData.isEmpty()) {
            return UpdateType.ADD;
        }

        var currentId = currentData.stream()
                .filter(t -> rule_code.equals(t.get("rule_code")))
                .findFirst()
                .map(t -> t.get("id"))
                .orElse(null);
        data.put("id", currentId);
        return currentId == null ? UpdateType.ADD : UpdateType.UPDATE;
    }
}
