package com.elitescloud.cloudt.system.service.devops.init;

import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.param.OrderItem;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * UDC.
 *
 * @author Kaiser（wang shao）
 * @date 2023/10/8
 */
public class PlatformUdcInitProvider extends AbstractBasicDataInitProvider {

    @Override
    public String typeName() {
        return "UDC";
    }

    @Override
    public String tableName() {
        return "sys_platform_udc";
    }

    @Override
    public List<String> fields() {
        return List.of("create_time", "modify_time", "app_code", "udc_code", "udc_name", "allow_update",
                "allow_add_value", "udc_describe", "parent_udc_code");
    }

    @Override
    public Map<String, String> fieldTitles() {
        Map<String, String> titles = new LinkedHashMap<>(16);
        titles.put("app_code", "应用编码");
        titles.put("udc_code", "UDC编码");
        titles.put("udc_name", "UDC名称");
        titles.put("allow_update", "是否允许编辑");
        titles.put("allow_add_value", "是否允许新增值");
        titles.put("udc_describe", "描述");
        titles.put("parent_udc_code", "上级UDC编码");
        titles.put("create_time", "创建时间");
        titles.put("modify_time", "最后修改时间");
        return titles;
    }

    @Override
    public List<OrderItem> orderItems() {
        return List.of(OrderItem.desc("app_code"), OrderItem.desc("create_time"));
    }

    @Override
    public UpdateType convertForImport(Map<String, Object> data, List<Map<String, Object>> currentData, List<Map<String, Object>> lastStepData) {
        var app_code = this.getStringValue(data, "app_code", null);
        Assert.notBlank(app_code, "应用编码为空");
        var udc_code = this.getStringValue(data, "udc_code", null);
        Assert.notBlank(udc_code, "UDC编码为空");

        this.normalizeBooleanValue(data, "allow_update");
        this.normalizeBooleanValue(data, "allow_add_value");

        if (currentData.isEmpty()) {
            return UpdateType.ADD;
        }

        var id = currentData.parallelStream()
                .filter(t -> app_code.equals(t.get("app_code")) && udc_code.equals(t.get("udc_code")))
                .findFirst()
                .map(t -> t.get("id"))
                .orElse(null);
        data.put("id", id);
        return id == null ? UpdateType.ADD : UpdateType.UPDATE;
    }
}
